/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.shared.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.moud.client.runtime.ClientScriptingRuntime;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.graalvm.polyglot.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientValueCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientValueCache.class);
    private final String storeName;
    private final ConcurrentHashMap<String, Object> values;
    private final ConcurrentHashMap<String, Boolean> modifiableKeys;
    private final CopyOnWriteArrayList<Value> changeListeners;
    private final ConcurrentHashMap<String, CopyOnWriteArrayList<Value>> keyListeners;

    public ClientValueCache(String storeName) {
        this.storeName = storeName;
        this.values = new ConcurrentHashMap();
        this.modifiableKeys = new ConcurrentHashMap();
        this.changeListeners = new CopyOnWriteArrayList();
        this.keyListeners = new ConcurrentHashMap();
    }

    public Object get(String key) {
        return this.cloneValue(this.values.get(key));
    }

    public boolean has(String key) {
        return this.values.containsKey(key);
    }

    public boolean canModify(String key) {
        return this.modifiableKeys.getOrDefault(key, false);
    }

    public void updateFromServer(String key, Object value) {
        Object oldValue = this.values.put(key, value);
        this.modifiableKeys.put(key, true);
        this.triggerChangeListeners(key, value, oldValue);
    }

    public void updateOptimistic(String key, Object value) {
        Object oldValue = this.values.put(key, value);
        this.triggerChangeListeners(key, value, oldValue);
    }

    public void addChangeListener(Value callback) {
        if (callback != null && callback.canExecute()) {
            this.changeListeners.add(callback);
        }
    }

    public void addKeyListener(String key, Value callback) {
        if (callback != null && callback.canExecute()) {
            this.keyListeners.computeIfAbsent(key, k -> new CopyOnWriteArrayList()).add(callback);
        }
    }

    public void removeChangeListener(Value callback) {
        this.changeListeners.remove(callback);
    }

    public String getStoreName() {
        return this.storeName;
    }

    private void triggerChangeListeners(String key, Object newValue, Object oldValue) {
        for (Value listener : this.changeListeners) {
            ClientScriptingRuntime.scheduleScriptTask(() -> {
                try {
                    if (listener.canExecute()) {
                        listener.execute(new Object[]{key, this.cloneValue(newValue), this.cloneValue(oldValue)});
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error in shared value 'change' listener for store '{}'", (Object)this.storeName, (Object)e);
                    this.changeListeners.remove(listener);
                }
            });
        }
        CopyOnWriteArrayList<Value> specificKeyListeners = this.keyListeners.get(key);
        if (specificKeyListeners != null) {
            for (Value listener : specificKeyListeners) {
                ClientScriptingRuntime.scheduleScriptTask(() -> {
                    try {
                        if (listener.canExecute()) {
                            listener.execute(new Object[]{this.cloneValue(newValue), this.cloneValue(oldValue)});
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error in shared value key '{}' listener for store '{}'", new Object[]{key, this.storeName, e});
                        specificKeyListeners.remove(listener);
                    }
                });
            }
        }
    }

    private Object cloneValue(Object value) {
        if (value == null || value instanceof String || value instanceof Number || value instanceof Boolean) {
            return value;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            String json = mapper.writeValueAsString(value);
            return mapper.readValue(json, Object.class);
        }
        catch (Exception e) {
            LOGGER.warn("Could not deep clone value of type {}, returning original. This may cause issues.", (Object)value.getClass().getName());
            return value;
        }
    }

    public void clear() {
        this.values.clear();
        this.modifiableKeys.clear();
        this.changeListeners.clear();
        this.keyListeners.clear();
    }
}

