/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.ui;

import com.moud.client.api.service.ClientAPIService;
import com.moud.client.api.service.UIService;
import com.moud.client.ui.UIFocusManager;
import com.moud.client.ui.component.UIComponent;
import com.moud.client.ui.component.UIContainer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIOverlayManager {
    private static UIOverlayManager instance;
    private final List<UIComponent> overlayElements = new CopyOnWriteArrayList<UIComponent>();
    private final class_310 client = class_310.method_1551();
    private int lastScreenWidth = -1;
    private int lastScreenHeight = -1;
    private static final Logger LOGGER;
    private long frameCount = 0L;

    private UIOverlayManager() {
    }

    public static synchronized UIOverlayManager getInstance() {
        if (instance == null) {
            instance = new UIOverlayManager();
        }
        return instance;
    }

    public void addOverlayElement(UIComponent element) {
        if (!this.overlayElements.contains(element)) {
            this.overlayElements.add(element);
            this.checkForResize();
        }
    }

    public void removeOverlayElement(UIComponent element) {
        if (this.overlayElements.remove(element)) {
            // empty if block
        }
    }

    public void renderOverlays(class_332 context, class_9779 tickCounter) {
        if (ClientAPIService.INSTANCE == null || ClientAPIService.INSTANCE.ui == null) {
            return;
        }
        this.checkForResize();
        UIService uiService = ClientAPIService.INSTANCE.ui;
        int mouseX = uiService.getMouseX();
        int mouseY = uiService.getMouseY();
        List<UIComponent> elementsToRender = this.getOverlayElements();
        for (UIComponent element : elementsToRender) {
            if (!element.isVisible()) continue;
            element.renderWidget(context, mouseX, mouseY, tickCounter.method_60637(true));
        }
    }

    public boolean handleOverlayClick(double mouseX, double mouseY, int button) {
        int scaledMouseX = (int)(mouseX * (double)this.client.method_22683().method_4486() / (double)this.client.method_22683().method_4480());
        int scaledMouseY = (int)(mouseY * (double)this.client.method_22683().method_4502() / (double)this.client.method_22683().method_4507());
        boolean elementClicked = false;
        List<UIComponent> currentElements = this.getOverlayElements();
        for (int i = currentElements.size() - 1; i >= 0; --i) {
            UIComponent element = currentElements.get(i);
            if (!element.isVisible() || !element.mouseClicked(scaledMouseX, scaledMouseY, button)) continue;
            elementClicked = true;
            break;
        }
        if (!elementClicked) {
            UIFocusManager.clearFocus();
        }
        return elementClicked;
    }

    public boolean handleOverlayKeyPress(int keyCode, int scanCode, int modifiers) {
        UIComponent focused = UIFocusManager.getFocusedComponent();
        return focused != null && this.overlayElements.contains(focused);
    }

    public boolean handleOverlayCharTyped(char chr, int modifiers) {
        UIComponent focused = UIFocusManager.getFocusedComponent();
        return focused != null && this.overlayElements.contains(focused);
    }

    private void checkForResize() {
        int currentWidth = this.client.method_22683().method_4486();
        int currentHeight = this.client.method_22683().method_4502();
        if (this.lastScreenWidth != currentWidth || this.lastScreenHeight != currentHeight) {
            this.onScreenResize(currentWidth, currentHeight);
            this.lastScreenWidth = currentWidth;
            this.lastScreenHeight = currentHeight;
        }
    }

    private void onScreenResize(int newWidth, int newHeight) {
        for (UIComponent element : this.getOverlayElements()) {
            if (!(element instanceof UIContainer)) continue;
            UIContainer container = (UIContainer)element;
            if (container.parent != null) continue;
            container.updateLayout();
        }
    }

    public void clear() {
        UIFocusManager.clearFocus();
        this.overlayElements.clear();
        this.lastScreenWidth = -1;
        this.lastScreenHeight = -1;
        LOGGER.info("[UI DEBUG] All UI elements cleared.");
    }

    public List<UIComponent> getOverlayElements() {
        return new CopyOnWriteArrayList<UIComponent>(this.overlayElements);
    }

    static {
        LOGGER = LoggerFactory.getLogger(UIOverlayManager.class);
    }
}

