/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.ui.component;

import com.moud.client.api.service.UIService;
import com.moud.client.ui.UIOverlayManager;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(UIComponent.class);
    private static final AtomicLong idCounter = new AtomicLong(0L);
    private final long uniqueId = idCounter.incrementAndGet();
    protected final String type;
    protected final UIService service;
    protected volatile String componentId;
    protected final Map<String, Value> eventHandlers = new ConcurrentHashMap<String, Value>();
    protected final List<UIComponent> children = new CopyOnWriteArrayList<UIComponent>();
    public UIComponent parent;
    protected volatile int x;
    protected volatile int y;
    protected volatile int width;
    protected volatile int height;
    protected volatile String backgroundColor = "#00000000";
    protected volatile String textColor = "#000000";
    protected volatile String borderColor = "#000000";
    protected volatile int borderWidth = 0;
    protected volatile double opacity = 1.0;
    protected volatile String textAlign = "left";
    protected volatile double paddingTop = 2.0;
    protected volatile double paddingRight = 4.0;
    protected volatile double paddingBottom = 2.0;
    protected volatile double paddingLeft = 4.0;
    protected volatile boolean visible = true;
    protected volatile class_2561 message = class_2561.method_43473();
    protected volatile boolean focused = false;

    public UIComponent(String type, UIService service) {
        this.type = type;
        this.service = service;
        this.x = 0;
        this.y = 0;
        this.width = 100;
        this.height = 20;
        this.message = class_2561.method_43470((String)"");
        this.componentId = UUID.randomUUID().toString();
    }

    public String getDebugIdentifier() {
        Object text = this.message.getString();
        if (((String)text).length() > 15) {
            text = ((String)text).substring(0, 12) + "...";
        }
        return String.format("%s[id:%d, text:'%s']", this.type, this.uniqueId, ((String)text).isEmpty() ? "N/A" : text);
    }

    public void renderWidget(class_332 context, int mouseX, int mouseY, float delta) {
        int borderCol;
        if (!this.visible) {
            return;
        }
        if (this.opacity <= 0.01) {
            return;
        }
        int bgColor = this.parseColor(this.backgroundColor, this.opacity);
        if (bgColor >>> 24 > 0) {
            context.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, bgColor);
        }
        if (this.borderWidth > 0 && (borderCol = this.parseColor(this.borderColor, this.opacity)) >>> 24 > 0) {
            for (int i = 0; i < this.borderWidth; ++i) {
                context.method_49601(this.x + i, this.y + i, this.width - i * 2, this.height - i * 2, borderCol);
            }
        }
        this.renderText(context);
        for (UIComponent child : this.children) {
            child.renderWidget(context, mouseX, mouseY, delta);
        }
    }

    protected void renderText(class_332 context) {
        if (this.message.getString().isEmpty()) {
            return;
        }
        int textCol = this.parseColor(this.textColor, this.opacity);
        if (textCol >>> 24 <= 0) {
            return;
        }
        int textWidth = class_310.method_1551().field_1772.method_27525((class_5348)this.message);
        Objects.requireNonNull(class_310.method_1551().field_1772);
        int textHeight = 9;
        int textX = switch (this.textAlign.toLowerCase()) {
            case "center" -> this.x + (this.width - textWidth) / 2;
            case "right" -> this.x + this.width - textWidth - (int)this.paddingRight;
            default -> this.x + (int)this.paddingLeft;
        };
        int textY = this.y + (this.height - textHeight) / 2;
        context.method_51439(class_310.method_1551().field_1772, this.message, textX, textY, textCol, false);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.visible || this.opacity <= 0.01) {
            return false;
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            if (!this.children.get(i).mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height)) {
            this.triggerClick(mouseX, mouseY, button);
            return true;
        }
        return false;
    }

    protected int parseColor(String colorStr, double elementOpacity) {
        if (colorStr == null || !colorStr.startsWith("#")) {
            return 0;
        }
        try {
            int blue;
            int green;
            int red;
            int alpha;
            long value = Long.parseLong(colorStr.substring(1), 16);
            if (colorStr.length() == 9) {
                alpha = (int)(value >> 24 & 0xFFL);
                red = (int)(value >> 16 & 0xFFL);
                green = (int)(value >> 8 & 0xFFL);
                blue = (int)(value & 0xFFL);
            } else if (colorStr.length() == 7) {
                alpha = 255;
                red = (int)(value >> 16 & 0xFFL);
                green = (int)(value >> 8 & 0xFFL);
                blue = (int)(value & 0xFFL);
            } else {
                return 0;
            }
            int finalAlpha = (int)((double)alpha * Math.max(0.0, Math.min(1.0, elementOpacity)));
            return finalAlpha << 24 | red << 16 | green << 8 | blue;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @HostAccess.Export
    public UIComponent showAsOverlay() {
        UIOverlayManager.getInstance().addOverlayElement(this);
        this.visible = true;
        return this;
    }

    @HostAccess.Export
    public UIComponent hideOverlay() {
        this.visible = false;
        return this;
    }

    @HostAccess.Export
    public int getX() {
        return this.x;
    }

    @HostAccess.Export
    public int getY() {
        return this.y;
    }

    @HostAccess.Export
    public int getWidth() {
        return this.width;
    }

    @HostAccess.Export
    public int getHeight() {
        return this.height;
    }

    @HostAccess.Export
    public UIComponent setX(int x) {
        this.x = x;
        return this;
    }

    @HostAccess.Export
    public UIComponent setY(int y) {
        this.y = y;
        return this;
    }

    @HostAccess.Export
    public UIComponent setWidth(int width) {
        this.width = width;
        return this;
    }

    @HostAccess.Export
    public UIComponent setHeight(int height) {
        this.height = height;
        return this;
    }

    @HostAccess.Export
    public String getComponentId() {
        return this.componentId;
    }

    @HostAccess.Export
    public UIComponent setComponentId(String id) {
        this.componentId = id;
        return this;
    }

    @HostAccess.Export
    public UIComponent setText(String text) {
        this.message = class_2561.method_43470((String)text);
        return this;
    }

    @HostAccess.Export
    public String getText() {
        return this.message.getString();
    }

    @HostAccess.Export
    public UIComponent setPos(double x, double y) {
        this.x = (int)x;
        this.y = (int)y;
        return this;
    }

    @HostAccess.Export
    public UIComponent setSize(double width, double height) {
        this.width = (int)width;
        this.height = (int)height;
        return this;
    }

    @HostAccess.Export
    public UIComponent setBackgroundColor(String color) {
        this.backgroundColor = color;
        return this;
    }

    @HostAccess.Export
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @HostAccess.Export
    public UIComponent setTextColor(String color) {
        this.textColor = color;
        return this;
    }

    @HostAccess.Export
    public String getTextColor() {
        return this.textColor;
    }

    @HostAccess.Export
    public UIComponent setBorder(int width, String color) {
        this.borderWidth = width;
        this.borderColor = color;
        return this;
    }

    @HostAccess.Export
    public int getBorderWidth() {
        return this.borderWidth;
    }

    @HostAccess.Export
    public String getBorderColor() {
        return this.borderColor;
    }

    @HostAccess.Export
    public UIComponent setOpacity(double opacity) {
        this.opacity = Math.max(0.0, Math.min(1.0, opacity));
        return this;
    }

    @HostAccess.Export
    public double getOpacity() {
        return this.opacity;
    }

    @HostAccess.Export
    public UIComponent setTextAlign(String align) {
        this.textAlign = align;
        return this;
    }

    @HostAccess.Export
    public String getTextAlign() {
        return this.textAlign;
    }

    @HostAccess.Export
    public UIComponent setPadding(double top, double right, double bottom, double left) {
        this.paddingTop = top;
        this.paddingRight = right;
        this.paddingBottom = bottom;
        this.paddingLeft = left;
        return this;
    }

    @HostAccess.Export
    public double getPaddingTop() {
        return this.paddingTop;
    }

    @HostAccess.Export
    public double getPaddingRight() {
        return this.paddingRight;
    }

    @HostAccess.Export
    public double getPaddingBottom() {
        return this.paddingBottom;
    }

    @HostAccess.Export
    public double getPaddingLeft() {
        return this.paddingLeft;
    }

    @HostAccess.Export
    public UIComponent appendChild(UIComponent child) {
        this.children.add(child);
        child.parent = this;
        return this;
    }

    @HostAccess.Export
    public UIComponent removeChild(UIComponent child) {
        this.children.remove(child);
        child.parent = null;
        return this;
    }

    @HostAccess.Export
    public List<UIComponent> getChildren() {
        return new CopyOnWriteArrayList<UIComponent>(this.children);
    }

    @HostAccess.Export
    public UIComponent show() {
        this.visible = true;
        return this;
    }

    @HostAccess.Export
    public UIComponent hide() {
        this.visible = false;
        return this;
    }

    @HostAccess.Export
    public boolean isVisible() {
        return this.visible;
    }

    @HostAccess.Export
    public UIComponent onClick(Value callback) {
        if (callback != null && callback.canExecute()) {
            this.eventHandlers.put("click", callback);
        }
        return this;
    }

    @HostAccess.Export
    public UIComponent onHover(Value callback) {
        if (callback != null && callback.canExecute()) {
            this.eventHandlers.put("hover", callback);
        }
        return this;
    }

    @HostAccess.Export
    public UIComponent onFocus(Value callback) {
        if (callback != null && callback.canExecute()) {
            this.eventHandlers.put("focus", callback);
        }
        return this;
    }

    @HostAccess.Export
    public UIComponent onBlur(Value callback) {
        if (callback != null && callback.canExecute()) {
            this.eventHandlers.put("blur", callback);
        }
        return this;
    }

    public void triggerClick(double mouseX, double mouseY, int button) {
        this.executeEventHandler("click", this, mouseX, mouseY, button);
    }

    public void triggerFocus() {
        this.executeEventHandler("focus", this);
    }

    public void triggerBlur() {
        this.executeEventHandler("blur", this);
    }

    protected void executeEventHandler(String eventType, Object ... args) {
        Value handler = this.eventHandlers.get(eventType);
        if (handler != null && this.service != null && this.service.getScriptExecutor() != null && !this.service.getScriptExecutor().isShutdown() && this.service.getJsContext() != null) {
            this.service.getScriptExecutor().execute(() -> {
                try {
                    this.service.getJsContext().enter();
                    handler.execute(args);
                }
                catch (Exception e) {
                    LOGGER.error("Error executing UI event handler for '{}' on element {}", new Object[]{eventType, this.componentId, e});
                }
                finally {
                    try {
                        this.service.getJsContext().leave();
                    }
                    catch (Exception exception) {}
                }
            });
        }
    }
}

