/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.ui.component;

import com.moud.client.api.service.UIService;
import com.moud.client.ui.component.UIComponent;
import org.graalvm.polyglot.HostAccess;

public class UIContainer
extends UIComponent {
    private volatile String flexDirection = "row";
    private volatile String justifyContent = "flex-start";
    private volatile String alignItems = "stretch";
    private volatile double gap = 0.0;
    private volatile boolean autoResize = true;
    private volatile boolean isUpdatingLayout = false;

    public UIContainer(UIService service) {
        super("container", service);
        this.setBackgroundColor("#00000000");
    }

    @Override
    @HostAccess.Export
    public UIComponent appendChild(UIComponent child) {
        super.appendChild(child);
        this.updateLayout();
        return this;
    }

    @HostAccess.Export
    public UIContainer setFlexDirection(String direction) {
        this.flexDirection = direction;
        this.updateLayout();
        return this;
    }

    @HostAccess.Export
    public String getFlexDirection() {
        return this.flexDirection;
    }

    @HostAccess.Export
    public UIContainer setJustifyContent(String justify) {
        this.justifyContent = justify;
        this.updateLayout();
        return this;
    }

    @HostAccess.Export
    public String getJustifyContent() {
        return this.justifyContent;
    }

    @HostAccess.Export
    public UIContainer setAlignItems(String align) {
        this.alignItems = align;
        this.updateLayout();
        return this;
    }

    @HostAccess.Export
    public String getAlignItems() {
        return this.alignItems;
    }

    @HostAccess.Export
    public UIContainer setGap(double gap) {
        this.gap = gap;
        this.updateLayout();
        return this;
    }

    @HostAccess.Export
    public double getGap() {
        return this.gap;
    }

    @HostAccess.Export
    public UIContainer setAutoResize(boolean autoResize) {
        this.autoResize = autoResize;
        this.updateLayout();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLayout() {
        if (this.isUpdatingLayout) {
            return;
        }
        this.isUpdatingLayout = true;
        try {
            if (this.children.isEmpty()) {
                if (this.autoResize) {
                    this.width = (int)(this.paddingLeft + this.paddingRight);
                    this.height = (int)(this.paddingTop + this.paddingBottom);
                }
                return;
            }
            int containerX = this.getX() + (int)this.paddingLeft;
            int containerY = this.getY() + (int)this.paddingTop;
            int containerWidth = this.getWidth() - (int)this.paddingLeft - (int)this.paddingRight;
            int containerHeight = this.getHeight() - (int)this.paddingTop - (int)this.paddingBottom;
            if ("row".equalsIgnoreCase(this.flexDirection)) {
                this.layoutRow(containerX, containerY, containerWidth, containerHeight);
            } else {
                this.layoutColumn(containerX, containerY, containerWidth, containerHeight);
            }
            if (this.autoResize) {
                this.resizeToContent();
            }
        }
        finally {
            this.isUpdatingLayout = false;
        }
    }

    private void layoutRow(int containerX, int containerY, int containerWidth, int containerHeight) {
        int totalChildWidth = this.children.stream().mapToInt(UIComponent::getWidth).sum();
        int totalGaps = this.children.size() > 1 ? (int)((double)(this.children.size() - 1) * this.gap) : 0;
        int usedSpace = totalChildWidth + totalGaps;
        int availableSpace = this.autoResize ? 0 : containerWidth - usedSpace;
        int currentX = containerX;
        double spaceBetween = this.gap;
        switch (this.justifyContent.toLowerCase()) {
            case "center": {
                currentX += availableSpace / 2;
                break;
            }
            case "flex-end": {
                currentX += availableSpace;
                break;
            }
            case "space-between": {
                if (this.children.size() <= 1) break;
                spaceBetween += (double)availableSpace / (double)(this.children.size() - 1);
                break;
            }
            case "space-around": {
                double space = (double)availableSpace / (double)this.children.size();
                currentX += (int)(space / 2.0);
                spaceBetween += space;
            }
        }
        for (UIComponent child : this.children) {
            int childY = containerY;
            switch (this.alignItems.toLowerCase()) {
                case "center": {
                    childY += (containerHeight - child.getHeight()) / 2;
                    break;
                }
                case "flex-end": {
                    childY += containerHeight - child.getHeight();
                    break;
                }
                case "stretch": {
                    if (this.autoResize) break;
                    child.setHeight(containerHeight);
                }
            }
            child.setPos(currentX, childY);
            currentX += child.getWidth() + (int)spaceBetween;
        }
    }

    private void layoutColumn(int containerX, int containerY, int containerWidth, int containerHeight) {
        int totalChildHeight = this.children.stream().mapToInt(UIComponent::getHeight).sum();
        int totalGaps = this.children.size() > 1 ? (int)((double)(this.children.size() - 1) * this.gap) : 0;
        int usedSpace = totalChildHeight + totalGaps;
        int availableSpace = this.autoResize ? 0 : containerHeight - usedSpace;
        int currentY = containerY;
        double spaceBetween = this.gap;
        switch (this.justifyContent.toLowerCase()) {
            case "center": {
                currentY += availableSpace / 2;
                break;
            }
            case "flex-end": {
                currentY += availableSpace;
                break;
            }
            case "space-between": {
                if (this.children.size() <= 1) break;
                spaceBetween += (double)availableSpace / (double)(this.children.size() - 1);
                break;
            }
            case "space-around": {
                double space = (double)availableSpace / (double)this.children.size();
                currentY += (int)(space / 2.0);
                spaceBetween += space;
            }
        }
        for (UIComponent child : this.children) {
            int childX = containerX;
            switch (this.alignItems.toLowerCase()) {
                case "center": {
                    childX += (containerWidth - child.getWidth()) / 2;
                    break;
                }
                case "flex-end": {
                    childX += containerWidth - child.getWidth();
                    break;
                }
                case "stretch": {
                    if (this.autoResize) break;
                    child.setWidth(containerWidth);
                }
            }
            child.setPos(childX, currentY);
            currentY += child.getHeight() + (int)spaceBetween;
        }
    }

    private void resizeToContent() {
        if (this.children.isEmpty()) {
            return;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (UIComponent child : this.children) {
            minX = Math.min(minX, child.getX());
            minY = Math.min(minY, child.getY());
            maxX = Math.max(maxX, child.getX() + child.getWidth());
            maxY = Math.max(maxY, child.getY() + child.getHeight());
        }
        int newWidth = maxX - minX + (int)this.paddingLeft + (int)this.paddingRight;
        int newHeight = maxY - minY + (int)this.paddingTop + (int)this.paddingBottom;
        if (newWidth != this.getWidth() || newHeight != this.getHeight()) {
            this.width = newWidth;
            this.height = newHeight;
            this.updateLayout();
        }
    }
}

