/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.ui.component;

import com.moud.client.api.service.UIService;
import com.moud.client.ui.component.UIComponent;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.graalvm.polyglot.HostAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UIImage
extends UIComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(UIImage.class);
    private volatile String source;
    private volatile class_2960 textureId;

    public UIImage(String source, UIService service) {
        super("image", service);
        this.setSource(source);
        this.setBackgroundColor("#00000000");
    }

    @Override
    public void renderWidget(class_332 context, int mouseX, int mouseY, float delta) {
        int borderCol;
        if (!this.visible || this.opacity <= 0.01 || this.textureId == null) {
            return;
        }
        context.method_51422(1.0f, 1.0f, 1.0f, (float)this.opacity);
        context.method_25290(this.textureId, this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), this.getWidth(), this.getHeight());
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.borderWidth > 0 && (borderCol = this.parseColor(this.borderColor, this.opacity)) >>> 24 > 0) {
            for (int i = 0; i < this.borderWidth; ++i) {
                context.method_49601(this.x + i, this.y + i, this.width - i * 2, this.height - i * 2, borderCol);
            }
        }
    }

    @HostAccess.Export
    public UIImage setSource(String source) {
        this.source = source;
        try {
            this.textureId = class_2960.method_12829((String)source);
            if (this.textureId == null) {
                LOGGER.warn("Invalid texture identifier provided for UIImage: {}", (Object)source);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse texture identifier for UIImage: {}", (Object)source, (Object)e);
            this.textureId = null;
        }
        return this;
    }

    @HostAccess.Export
    public String getSource() {
        return this.source;
    }
}

