/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.ui.component;

import com.moud.client.api.service.UIService;
import com.moud.client.ui.UIFocusManager;
import com.moud.client.ui.component.UIComponent;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;

public class UIInput
extends UIComponent {
    private volatile String value = "";
    private final String placeholder;
    private volatile int cursorPosition = 0;
    private volatile int selectionStart = 0;
    private volatile int selectionEnd = 0;
    private volatile long lastBlinkTime = 0L;
    private volatile boolean showCursor = true;

    public UIInput(String placeholder, UIService service) {
        super("input", service);
        this.placeholder = placeholder;
        this.setBackgroundColor("#FFFFFF");
        this.setBorder(1, "#CCCCCC");
        this.setTextAlign("left");
        this.setPadding(2.0, 6.0, 2.0, 6.0);
    }

    @Override
    protected void renderText(class_332 context) {
        String displayText = this.getDisplayText();
        if (displayText.isEmpty()) {
            return;
        }
        int textCol = this.parseColor(this.value.isEmpty() && !this.focused ? "#999999" : this.textColor, this.opacity);
        int textX = this.getX() + (int)this.paddingLeft;
        int n = this.getY();
        int n2 = this.getHeight();
        Objects.requireNonNull(class_310.method_1551().field_1772);
        int textY = n + (n2 - 9) / 2;
        if (this.hasSelection()) {
            this.renderSelection(context, displayText, textX, textY);
        }
        context.method_51439(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)displayText), textX, textY, textCol, false);
        if (this.focused && this.shouldShowCursor()) {
            this.renderCursor(context, displayText, textX, textY);
        }
    }

    private String getDisplayText() {
        if (!this.value.isEmpty()) {
            return this.value;
        }
        if (this.focused) {
            return "";
        }
        return this.placeholder;
    }

    private boolean shouldShowCursor() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastBlinkTime > 530L) {
            this.showCursor = !this.showCursor;
            this.lastBlinkTime = currentTime;
        }
        return this.showCursor;
    }

    private void renderCursor(class_332 context, String text, int textX, int textY) {
        String textBeforeCursor = text.substring(0, Math.min(this.cursorPosition, text.length()));
        int cursorX = textX + class_310.method_1551().field_1772.method_1727(textBeforeCursor);
        int cursorColor = this.parseColor(this.textColor, this.opacity);
        Objects.requireNonNull(class_310.method_1551().field_1772);
        context.method_25294(cursorX, textY - 1, cursorX + 1, textY + 9 + 1, cursorColor);
    }

    private boolean hasSelection() {
        return this.selectionStart != this.selectionEnd;
    }

    private void renderSelection(class_332 context, String text, int textX, int textY) {
        if (!this.hasSelection()) {
            return;
        }
        int start = Math.min(this.selectionStart, this.selectionEnd);
        int end = Math.max(this.selectionStart, this.selectionEnd);
        String beforeSelection = text.substring(0, start);
        String selection = text.substring(start, end);
        int selectionX = textX + class_310.method_1551().field_1772.method_1727(beforeSelection);
        int selectionWidth = class_310.method_1551().field_1772.method_1727(selection);
        Objects.requireNonNull(class_310.method_1551().field_1772);
        context.method_25294(selectionX, textY - 1, selectionX + selectionWidth, textY + 9 + 1, -1724684596);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY)) {
            UIFocusManager.setFocus(this);
            this.cursorPosition = this.getCharacterIndexAt(mouseX);
            this.clearSelection();
            return true;
        }
        return false;
    }

    private boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
    }

    private int getCharacterIndexAt(double mouseX) {
        if (this.value.isEmpty()) {
            return 0;
        }
        int relativeX = (int)(mouseX - (double)this.getX() - this.paddingLeft);
        for (int i = 0; i <= this.value.length(); ++i) {
            String substr = this.value.substring(0, i);
            int width = class_310.method_1551().field_1772.method_1727(substr);
            if (width < relativeX) continue;
            return i;
        }
        return this.value.length();
    }

    @HostAccess.Export
    public String getValue() {
        return this.value;
    }

    @HostAccess.Export
    public UIInput setValue(String value) {
        String oldValue = this.value;
        this.value = value == null ? "" : value;
        this.cursorPosition = Math.min(this.cursorPosition, this.value.length());
        this.clearSelection();
        this.triggerChange(this.value, oldValue);
        return this;
    }

    @HostAccess.Export
    public String getPlaceholder() {
        return this.placeholder;
    }

    @HostAccess.Export
    public UIInput onChange(Value callback) {
        if (callback != null && callback.canExecute()) {
            this.eventHandlers.put("change", callback);
        }
        return this;
    }

    private void triggerChange(String newValue, String oldValue) {
        this.executeEventHandler("change", this, newValue, oldValue);
    }

    public void handleCharTyped(char character) {
        if (!this.focused || !this.isValidCharacter(character)) {
            return;
        }
        if (this.hasSelection()) {
            this.deleteSelection();
        }
        String newValue = this.value.substring(0, this.cursorPosition) + character + this.value.substring(this.cursorPosition);
        this.setValue(newValue);
        ++this.cursorPosition;
    }

    @Override
    public void triggerFocus() {
        this.focused = true;
        super.triggerFocus();
    }

    @Override
    public void triggerBlur() {
        this.focused = false;
        super.triggerBlur();
    }

    @HostAccess.Export
    public UIInput onSubmit(Value callback) {
        if (callback != null && callback.canExecute()) {
            this.eventHandlers.put("submit", callback);
        }
        return this;
    }

    private void triggerSubmit() {
        this.executeEventHandler("submit", this, this.value);
    }

    public boolean handleKeyPressed(int keyCode) {
        if (!this.focused) {
            return false;
        }
        boolean ctrl = this.hasControlDown();
        boolean shift = this.hasShiftDown();
        if (keyCode == 256) {
            UIFocusManager.clearFocus();
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            this.triggerSubmit();
            UIFocusManager.clearFocus();
            return true;
        }
        switch (keyCode) {
            case 259: {
                if (this.hasSelection()) {
                    this.deleteSelection();
                    break;
                }
                if (this.cursorPosition <= 0) break;
                this.setValue(this.value.substring(0, this.cursorPosition - 1) + this.value.substring(this.cursorPosition));
                --this.cursorPosition;
                break;
            }
            case 261: {
                if (this.hasSelection()) {
                    this.deleteSelection();
                    break;
                }
                if (this.cursorPosition >= this.value.length()) break;
                this.setValue(this.value.substring(0, this.cursorPosition) + this.value.substring(this.cursorPosition + 1));
                break;
            }
            case 263: {
                if (shift) {
                    if (this.selectionStart == this.selectionEnd) {
                        this.selectionStart = this.cursorPosition;
                    }
                    this.selectionEnd = this.cursorPosition = Math.max(0, this.cursorPosition - 1);
                    break;
                }
                this.cursorPosition = Math.max(0, this.cursorPosition - 1);
                this.clearSelection();
                break;
            }
            case 262: {
                if (shift) {
                    if (this.selectionStart == this.selectionEnd) {
                        this.selectionStart = this.cursorPosition;
                    }
                    this.selectionEnd = this.cursorPosition = Math.min(this.value.length(), this.cursorPosition + 1);
                    break;
                }
                this.cursorPosition = Math.min(this.value.length(), this.cursorPosition + 1);
                this.clearSelection();
                break;
            }
            case 268: {
                if (shift) {
                    if (this.selectionStart == this.selectionEnd) {
                        this.selectionStart = this.cursorPosition;
                    }
                    this.selectionEnd = this.cursorPosition = 0;
                    break;
                }
                this.cursorPosition = 0;
                this.clearSelection();
                break;
            }
            case 269: {
                if (shift) {
                    if (this.selectionStart == this.selectionEnd) {
                        this.selectionStart = this.cursorPosition;
                    }
                    this.selectionEnd = this.cursorPosition = this.value.length();
                    break;
                }
                this.cursorPosition = this.value.length();
                this.clearSelection();
                break;
            }
            case 65: {
                if (!ctrl) break;
                this.selectAll();
                break;
            }
            case 67: {
                if (!ctrl || !this.hasSelection()) break;
                this.copySelection();
                break;
            }
            case 86: {
                if (!ctrl) break;
                this.pasteFromClipboard();
                break;
            }
            case 88: {
                if (!ctrl || !this.hasSelection()) break;
                this.copySelection();
                this.deleteSelection();
                break;
            }
            default: {
                return false;
            }
        }
        this.showCursor = true;
        this.lastBlinkTime = System.currentTimeMillis();
        return true;
    }

    private void deleteSelection() {
        if (!this.hasSelection()) {
            return;
        }
        int start = Math.min(this.selectionStart, this.selectionEnd);
        int end = Math.max(this.selectionStart, this.selectionEnd);
        this.setValue(this.value.substring(0, start) + this.value.substring(end));
        this.cursorPosition = start;
        this.clearSelection();
    }

    private void clearSelection() {
        this.selectionStart = this.cursorPosition;
        this.selectionEnd = this.cursorPosition;
    }

    private void selectAll() {
        this.selectionStart = 0;
        this.selectionEnd = this.value.length();
        this.cursorPosition = this.value.length();
    }

    private void copySelection() {
        if (!this.hasSelection()) {
            return;
        }
        int start = Math.min(this.selectionStart, this.selectionEnd);
        int end = Math.max(this.selectionStart, this.selectionEnd);
        String selectedText = this.value.substring(start, end);
        try {
            class_310.method_1551().field_1774.method_1455(selectedText);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void pasteFromClipboard() {
        try {
            String clipboardText = class_310.method_1551().field_1774.method_1460();
            if (clipboardText != null && !clipboardText.isEmpty()) {
                if (this.hasSelection()) {
                    this.deleteSelection();
                }
                String filteredText = this.filterClipboardText(clipboardText);
                String newValue = this.value.substring(0, this.cursorPosition) + filteredText + this.value.substring(this.cursorPosition);
                this.setValue(newValue);
                this.cursorPosition += filteredText.length();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String filterClipboardText(String text) {
        StringBuilder filtered = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (!this.isValidCharacter(c)) continue;
            filtered.append(c);
        }
        return filtered.toString();
    }

    private boolean isValidCharacter(char character) {
        return character >= ' ' && character != '\u007f';
    }

    private boolean hasControlDown() {
        return class_437.method_25441();
    }

    private boolean hasShiftDown() {
        return class_437.method_25442();
    }
}

