/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.ui.theme;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ThemeManager {
    private final Map<String, Theme> themes = new ConcurrentHashMap<String, Theme>();
    private Theme currentTheme;

    public ThemeManager() {
        this.loadDefaultThemes();
        this.currentTheme = this.themes.get("default");
    }

    private void loadDefaultThemes() {
        Theme defaultTheme = new Theme("default");
        defaultTheme.setColor("primary", "#4A90E2");
        defaultTheme.setColor("secondary", "#7B68EE");
        defaultTheme.setColor("background", "#FFFFFF");
        defaultTheme.setColor("text", "#000000");
        defaultTheme.setColor("border", "#CCCCCC");
        this.themes.put("default", defaultTheme);
        Theme darkTheme = new Theme("dark");
        darkTheme.setColor("primary", "#5DADE2");
        darkTheme.setColor("secondary", "#BB86FC");
        darkTheme.setColor("background", "#121212");
        darkTheme.setColor("text", "#FFFFFF");
        darkTheme.setColor("border", "#444444");
        this.themes.put("dark", darkTheme);
    }

    public void setTheme(String themeName) {
        Theme theme = this.themes.get(themeName);
        if (theme != null) {
            this.currentTheme = theme;
        }
    }

    public String getColor(String colorName) {
        return this.currentTheme != null ? this.currentTheme.getColor(colorName) : "#FFFFFF";
    }

    public Theme getCurrentTheme() {
        return this.currentTheme;
    }

    public void addTheme(Theme theme) {
        this.themes.put(theme.getName(), theme);
    }

    public static class Theme {
        private final String name;
        private final Map<String, String> colors = new ConcurrentHashMap<String, String>();

        public Theme(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setColor(String colorName, String colorValue) {
            this.colors.put(colorName, colorValue);
        }

        public String getColor(String colorName) {
            return this.colors.getOrDefault(colorName, "#FFFFFF");
        }
    }
}

