/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.util;

import com.moud.api.math.Easing;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Function;
import net.minecraft.class_310;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowAnimator {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowAnimator.class);
    private static boolean isAnimating = false;
    private static long startTime;
    private static long duration;
    private static int startX;
    private static int startY;
    private static int startWidth;
    private static int startHeight;
    private static int targetX;
    private static int targetY;
    private static int targetWidth;
    private static int targetHeight;
    private static int originalX;
    private static int originalY;
    private static int originalWidth;
    private static int originalHeight;
    private static boolean originalStateSaved;
    private static Function<Double, Double> easingFunction;
    private static final Queue<AnimationStep> animationQueue;

    public static void startSequence(List<Map<String, Object>> steps) {
        animationQueue.clear();
        originalStateSaved = false;
        for (Map<String, Object> stepData : steps) {
            int tX = stepData.get("x") != null ? ((Number)stepData.get("x")).intValue() : -1;
            int tY = stepData.get("y") != null ? ((Number)stepData.get("y")).intValue() : -1;
            int tW = stepData.get("width") != null ? ((Number)stepData.get("width")).intValue() : -1;
            int tH = stepData.get("height") != null ? ((Number)stepData.get("height")).intValue() : -1;
            int dur = stepData.get("duration") != null ? ((Number)stepData.get("duration")).intValue() : 500;
            String easing = stepData.get("easing") != null ? (String)stepData.get("easing") : "ease-out-quad";
            boolean isRestore = stepData.get("restore") != null && (Boolean)stepData.get("restore") != false;
            animationQueue.add(new AnimationStep(tX, tY, tW, tH, dur, easing, isRestore));
        }
        if (!isAnimating) {
            WindowAnimator.startNextAnimationInQueue();
        }
    }

    public static void startAnimation(int tX, int tY, int tW, int tH, int dur, String easing) {
        animationQueue.clear();
        originalStateSaved = false;
        animationQueue.add(new AnimationStep(tX, tY, tW, tH, dur, easing, false));
        if (!isAnimating) {
            WindowAnimator.startNextAnimationInQueue();
        }
    }

    public static void restore(int dur, String easing) {
        if (!originalStateSaved) {
            LOGGER.warn("WindowAnimator.restore() was called without a prior animation. Cannot restore.");
            return;
        }
        animationQueue.clear();
        animationQueue.add(new AnimationStep(0, 0, 0, 0, dur, easing, true));
        if (!isAnimating) {
            WindowAnimator.startNextAnimationInQueue();
        }
    }

    private static void startNextAnimationInQueue() {
        int[] height;
        int[] width;
        int[] ypos;
        int[] xpos;
        if (animationQueue.isEmpty()) {
            isAnimating = false;
            originalStateSaved = false;
            return;
        }
        AnimationStep nextStep = animationQueue.poll();
        class_310 client = class_310.method_1551();
        long handle = client.method_22683().method_4490();
        if (!originalStateSaved) {
            xpos = new int[1];
            ypos = new int[1];
            GLFW.glfwGetWindowPos((long)handle, (int[])xpos, (int[])ypos);
            originalX = xpos[0];
            originalY = ypos[0];
            width = new int[1];
            height = new int[1];
            GLFW.glfwGetWindowSize((long)handle, (int[])width, (int[])height);
            originalWidth = width[0];
            originalHeight = height[0];
            originalStateSaved = true;
        }
        xpos = new int[1];
        ypos = new int[1];
        GLFW.glfwGetWindowPos((long)handle, (int[])xpos, (int[])ypos);
        startX = xpos[0];
        startY = ypos[0];
        width = new int[1];
        height = new int[1];
        GLFW.glfwGetWindowSize((long)handle, (int[])width, (int[])height);
        startWidth = width[0];
        startHeight = height[0];
        if (nextStep.isRestore()) {
            targetX = originalX;
            targetY = originalY;
            targetWidth = originalWidth;
            targetHeight = originalHeight;
        } else {
            targetX = nextStep.tX == -1 ? startX : nextStep.tX;
            targetY = nextStep.tY == -1 ? startY : nextStep.tY;
            targetWidth = nextStep.tW == -1 ? startWidth : nextStep.tW;
            targetHeight = nextStep.tH == -1 ? startHeight : nextStep.tH;
        }
        duration = Math.max(1, nextStep.dur);
        startTime = System.nanoTime() / 1000000L;
        easingFunction = Easing.get((String)nextStep.easing);
        isAnimating = true;
    }

    public static void tick() {
        if (!isAnimating) {
            return;
        }
        long currentTime = System.nanoTime() / 1000000L;
        long elapsedTime = currentTime - startTime;
        double progress = Math.min((double)elapsedTime / (double)duration, 1.0);
        double easedProgress = easingFunction.apply(progress);
        int newX = (int)((double)startX + (double)(targetX - startX) * easedProgress);
        int newY = (int)((double)startY + (double)(targetY - startY) * easedProgress);
        int newWidth = (int)((double)startWidth + (double)(targetWidth - startWidth) * easedProgress);
        int newHeight = (int)((double)startHeight + (double)(targetHeight - startHeight) * easedProgress);
        class_310 client = class_310.method_1551();
        client.execute(() -> {
            long handle = client.method_22683().method_4490();
            if (handle != 0L) {
                if (newX != startX || newY != startY) {
                    GLFW.glfwSetWindowPos((long)handle, (int)newX, (int)newY);
                }
                if (newWidth != startWidth || newHeight != startHeight) {
                    GLFW.glfwSetWindowSize((long)handle, (int)newWidth, (int)newHeight);
                }
            }
        });
        if (progress >= 1.0) {
            WindowAnimator.startNextAnimationInQueue();
        }
    }

    static {
        originalStateSaved = false;
        animationQueue = new LinkedList<AnimationStep>();
    }

    private record AnimationStep(int tX, int tY, int tW, int tH, int dur, String easing, boolean isRestore) {
    }
}

