/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import jn.willfrydev.command.MotdCommand;
import jn.willfrydev.config.MotdConfig;
import jn.willfrydev.listener.PingListener;
import jn.willfrydev.motd.MotdManager;
import org.slf4j.Logger;

@Plugin(id="motd777", name="777Motd", version="1.0", authors={"WillFryDev"})
public final class SevenSevenSevenMotd {
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDir;
    private MotdConfig config;
    private MotdManager motdManager;
    private PingListener listener;

    @Inject
    public SevenSevenSevenMotd(ProxyServer server, Logger logger, @DataDirectory Path dataDir) {
        this.server = server;
        this.logger = logger;
        this.dataDir = dataDir;
    }

    @Subscribe
    public void onInit(ProxyInitializeEvent e) {
        this.config = new MotdConfig(this.dataDir);
        this.config.reload();
        this.motdManager = new MotdManager(this.server, this.config);
        this.listener = new PingListener(this.server, this.config, this.motdManager, this.dataDir);
        this.server.getEventManager().register((Object)this, (Object)this.listener);
        this.server.getCommandManager().register("777motd", (Command)new MotdCommand(this.server, this.config, this.motdManager, this.listener), new String[]{"motd777"});
        this.printBanner();
    }

    private void printBanner() {
        this.logger.info("\n ________ ________ ________       _____ ______   ________  _________  ________     \n|\\_____  \\\\_____  \\\\_____  \\     |\\   _ \\  _   \\\\   __  \\\\___   ___\\\\   ___ \\    \n \\|___/  /\\|___/  /\\|___/  /|    \\ \\  \\\\\\__\\ \\  \\\\  \\|\\  \\|___ \\  \\_\\ \\  \\_|\\ \\   \n     /  / /   /  / /   /  / /     \\ \\  \\\\|__| \\  \\\\  \\\\\\  \\   \\ \\  \\ \\ \\  \\ \\\\ \\  \n    /  / /   /  / /   /  / /       \\ \\  \\    \\ \\  \\\\  \\\\\\  \\   \\ \\  \\ \\ \\  \\_\\\\ \\ \n   /__/ /   /__/ /   /__/ /         \\ \\__\\    \\ \\__\\\\_______\\   \\ \\__\\ \\ \\_______\\\n   |__|/    |__|/    |__|/           \\|__|     \\|__|\\|_______|    \\|__|  \\|_______|\n                                                                                   \n                                                                                   \n                                                                                   \n                         777Motd v1.0 - by WillFryDev                              \n");
    }
}

