/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.command;

import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jn.willfrydev.config.MotdConfig;
import jn.willfrydev.listener.PingListener;
import jn.willfrydev.motd.MotdManager;
import net.kyori.adventure.text.Component;

public final class MotdCommand
implements SimpleCommand {
    private final ProxyServer server;
    private final MotdConfig config;
    private final MotdManager motd;
    private final PingListener listener;

    public MotdCommand(ProxyServer server, MotdConfig config, MotdManager motd, PingListener listener) {
        this.server = server;
        this.config = config;
        this.motd = motd;
        this.listener = listener;
    }

    public void execute(SimpleCommand.Invocation inv) {
        String[] args = (String[])inv.arguments();
        if (args.length == 0) {
            inv.source().sendMessage((Component)Component.text("\u00a7bUso: \u00a7a/777motd <reload|preview>"));
            return;
        }
        switch (args[0].toLowerCase(Locale.ROOT)) {
            case "reload": {
                if (!inv.source().hasPermission("777motd.reload")) {
                    inv.source().sendMessage((Component)Component.text("\u00a7cNo tienes permiso (777motd.reload)."));
                    return;
                }
                this.config.reload();
                if (this.listener != null) {
                    this.listener.onConfigReload();
                }
                inv.source().sendMessage((Component)Component.text("\u00a7a[777Motd] Config recargada."));
                break;
            }
            case "preview": {
                Map<String, List<String>> sections = this.config.motdSections();
                List<String> lines = null;
                if (sections != null && !sections.isEmpty() && ((lines = sections.get("default")) == null || lines.isEmpty())) {
                    for (List<String> l : sections.values()) {
                        if (l == null || l.isEmpty()) continue;
                        lines = l;
                        break;
                    }
                }
                if (lines == null) {
                    lines = List.of("&b777Motd", "&7Config vac\u00eda");
                }
                int online = this.server.getPlayerCount();
                int max = this.server.getConfiguration().getShowMaxPlayers();
                Component preview = this.motd.buildMotd(lines, true, online, max, "Velocity");
                inv.source().sendMessage((Component)Component.text("\u00a77[Vista previa de MOTD]"));
                inv.source().sendMessage(preview);
                break;
            }
            default: {
                inv.source().sendMessage((Component)Component.text("\u00a7bUso: \u00a7a/777motd <reload|preview>"));
            }
        }
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return true;
    }
}

