/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.config;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public final class MotdConfig {
    private final Path dataFolder;
    private final Path filePath;
    private YamlConfigurationLoader loader;
    private ConfigurationNode root;

    public MotdConfig(Path dataFolder) {
        this.dataFolder = dataFolder;
        this.filePath = dataFolder.resolve("config.yml");
        this.loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(this.filePath)).nodeStyle(NodeStyle.BLOCK).build();
    }

    public void reload() {
        this.ensureDefaults();
        try {
            this.root = this.loader.load(ConfigurationOptions.defaults());
        }
        catch (IOException e) {
            throw new RuntimeException("Error al cargar config.yml", e);
        }
    }

    public void reload(Path ignored) {
        this.reload();
    }

    public boolean enabled() {
        return this.root.node("enabled").getBoolean(true);
    }

    public boolean central() {
        return this.root.node("central").getBoolean(false);
    }

    public boolean faviconEnabled() {
        return this.root.node("favicon", "enabled").getBoolean(true);
    }

    public String faviconFile() {
        return this.root.node("favicon", "file").getString("icons/favicon.png");
    }

    public Map<String, List<String>> motdSections() {
        LinkedHashMap<String, List<String>> out = new LinkedHashMap<String, List<String>>();
        ConfigurationNode sec = this.root.node("motds");
        if (sec.virtual() || sec.isNull()) {
            return out;
        }
        for (Map.Entry<Object, ? extends ConfigurationNode> e : sec.childrenMap().entrySet()) {
            String key = String.valueOf(e.getKey());
            ArrayList<String> lines = new ArrayList<String>();
            for (ConfigurationNode configurationNode : e.getValue().childrenList()) {
                String line = configurationNode.getString();
                if (line == null) continue;
                lines.add(line);
            }
            out.put(key, lines);
        }
        return out;
    }

    public Map<String, List<String>> motds() {
        return this.motdSections();
    }

    private void ensureDefaults() {
        block10: {
            try {
                Files.createDirectories(this.dataFolder, new FileAttribute[0]);
                if (!Files.notExists(this.filePath, new LinkOption[0])) break block10;
                try (InputStream in = this.getClass().getResourceAsStream("/config.yml");){
                    if (in != null) {
                        Files.copy(in, this.filePath, new CopyOption[0]);
                    } else {
                        String def = "enabled: true\ncentral: true\n\nmotds:\n  default:\n    - \"&aBienvenido a &b777Network\"\n    - \"&7Jugadores conectados: &f%%online%%/&f%%max%%\"\n\n  web:\n    - \"&bCon\u00e9ctate desde la web oficial!\"\n    - \"&7Versi\u00f3n: &f%%version%%\"\n\n  tienda:\n    - \"&6Visita nuestra tienda\"\n    - \"&eOfertas cada semana\"\n\nfavicon:\n  enabled: true\n  file: \"icons/favicon.png\"\n\nsample:\n  enabled: false\n  lines:\n    - \"&7Discord: &bdiscord.gg/mi-servidor\"\n    - \"&aS\u00edguenos: &f@777Network\"\n";
                        Files.writeString(this.filePath, (CharSequence)def, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("No se pudo crear/cargar config.yml", e);
            }
        }
    }
}

