/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.listener;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyPingEvent;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.ServerPing;
import com.velocitypowered.api.util.Favicon;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import jn.willfrydev.config.MotdConfig;
import jn.willfrydev.motd.MotdManager;
import net.kyori.adventure.text.Component;

public final class PingListener {
    private final ProxyServer server;
    private final MotdConfig config;
    private final MotdManager motd;
    private final Path dataFolder;
    private volatile Favicon cachedFavicon;
    private volatile String cachedFileName;
    private volatile long cachedMtime = -1L;

    public PingListener(ProxyServer server, MotdConfig config, MotdManager motd, Path dataFolder) {
        this.server = server;
        this.config = config;
        this.motd = motd;
        this.dataFolder = dataFolder;
        this.ensureIconFolder();
        this.warmupFavicon();
    }

    @Subscribe
    public void onInit(ProxyInitializeEvent e) {
        this.ensureIconFolder();
        this.warmupFavicon();
    }

    @Subscribe
    public void onPing(ProxyPingEvent event) {
        if (!this.config.enabled()) {
            return;
        }
        List<String> lines = this.resolveLines(event);
        int online = this.server.getPlayerCount();
        int max = this.server.getConfiguration().getShowMaxPlayers();
        String versionName = event.getPing().getVersion() != null ? event.getPing().getVersion().getName() : "Minecraft";
        Component comp = this.motd.buildMotd(lines, this.config.central(), online, max, versionName);
        ServerPing ping = event.getPing();
        event.setPing(ping.asBuilder().description(comp).build());
        Favicon fav = this.getCachedFaviconIfAny();
        if (fav != null) {
            event.setPing(event.getPing().asBuilder().favicon(fav).build());
        }
    }

    private List<String> resolveLines(ProxyPingEvent event) {
        Map<String, List<String>> sections = this.config.motdSections();
        if (sections == null || sections.isEmpty()) {
            return List.of("&b777Motd", "&7Config vac\u00eda");
        }
        List<String> def = sections.get("default");
        if (def != null && !def.isEmpty()) {
            return def;
        }
        for (List<String> l : sections.values()) {
            if (l == null || l.isEmpty()) continue;
            return l;
        }
        return List.of("&b777Motd", "&7Sin motds");
    }

    private void ensureIconFolder() {
        try {
            Path out;
            Path parent;
            String rel = this.config.faviconFile();
            if (rel == null || rel.isEmpty()) {
                rel = "icons/favicon.png";
            }
            if ((parent = (out = this.dataFolder.resolve(rel).normalize()).getParent()) != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onConfigReload() {
        this.cachedFavicon = null;
        this.cachedFileName = null;
        this.cachedMtime = -1L;
        this.ensureIconFolder();
        this.warmupFavicon();
    }

    private void warmupFavicon() {
        if (!this.config.faviconEnabled()) {
            this.cachedFavicon = null;
            return;
        }
        String rel = this.config.faviconFile();
        if (rel == null || rel.isEmpty()) {
            rel = "icons/favicon.png";
        }
        Path file = this.dataFolder.resolve(rel).normalize();
        try {
            String[] candidates;
            if (Files.exists(file, new LinkOption[0])) {
                long mtime = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
                if (!rel.equals(this.cachedFileName) || this.cachedFavicon == null || mtime != this.cachedMtime) {
                    this.cachedFavicon = this.loadFaviconFromPath(file);
                    this.cachedFileName = rel;
                    this.cachedMtime = mtime;
                }
                return;
            }
            for (String res : candidates = new String[]{"/" + rel, "/icons/favicon.png", "/favicon.png"}) {
                try (InputStream in = this.getClass().getResourceAsStream(res);){
                    if (in == null) continue;
                    this.cachedFavicon = this.loadFaviconFromStream(in);
                    this.cachedFileName = rel;
                    this.cachedMtime = -1L;
                    return;
                }
            }
            this.cachedFavicon = null;
            this.cachedFileName = null;
            this.cachedMtime = -1L;
        }
        catch (Exception ignored) {
            this.cachedFavicon = null;
        }
    }

    private Favicon getCachedFaviconIfAny() {
        try {
            Path file;
            String rel = this.config.faviconFile();
            if (rel == null || rel.isEmpty()) {
                rel = "icons/favicon.png";
            }
            if (Files.exists(file = this.dataFolder.resolve(rel).normalize(), new LinkOption[0])) {
                long mtime = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
                if (!rel.equals(this.cachedFileName) || this.cachedFavicon == null || mtime != this.cachedMtime) {
                    this.warmupFavicon();
                }
            } else if (!Objects.equals(this.cachedFileName, rel)) {
                this.warmupFavicon();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.cachedFavicon;
    }

    private Favicon loadFaviconFromPath(Path path) {
        Favicon favicon;
        block8: {
            InputStream in = Files.newInputStream(path, new OpenOption[0]);
            try {
                favicon = this.loadFaviconFromStream(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            in.close();
        }
        return favicon;
    }

    private Favicon loadFaviconFromStream(InputStream in) {
        try {
            BufferedImage img = ImageIO.read(in);
            if (img == null) {
                return null;
            }
            return Favicon.create((BufferedImage)img);
        }
        catch (Exception e) {
            return null;
        }
    }
}

