/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.motd;

import com.velocitypowered.api.proxy.ProxyServer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import jn.willfrydev.config.MotdConfig;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public final class MotdManager {
    private static final int CENTER_TARGET = 50;
    private final ProxyServer server;
    private final MotdConfig config;
    private final LegacyComponentSerializer legacy = LegacyComponentSerializer.builder().character('&').hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    private static final Pattern STRIP_LEGACY = Pattern.compile("(?i)&[0-9A-FK-OR]|(?:&x(?:&[0-9A-F]){6})");
    private static final Pattern HEX_HASH = Pattern.compile("(?i)&#([0-9A-F]{6})");

    public MotdManager(ProxyServer server, MotdConfig config) {
        this.server = server;
        this.config = config;
    }

    public Component buildMotd(List<String> lines, boolean center, int online, int max, String versionName) {
        String motdRaw = this.joinTwo(lines);
        motdRaw = this.applyPlaceholders(motdRaw, online, max, versionName);
        motdRaw = this.normalizeHex(motdRaw);
        if (center) {
            motdRaw = this.centerLines(motdRaw);
        }
        return this.legacy.deserialize(motdRaw);
    }

    public Component buildPreview() {
        ArrayList<String> demo = new ArrayList<String>();
        demo.add("&aBienvenido a &b777Motd");
        demo.add("&7Jugadores: &f%%online%%/&f%%max%%  &8(%%version%%)");
        String version = "Velocity";
        return this.buildMotd(demo, this.config.central(), this.server.getPlayerCount(), this.server.getConfiguration().getShowMaxPlayers(), version);
    }

    private String joinTwo(List<String> lines) {
        if (lines == null || lines.isEmpty()) {
            return "";
        }
        if (lines.size() == 1) {
            return lines.get(0);
        }
        return lines.get(0) + "\n" + lines.get(1);
    }

    private String applyPlaceholders(String s, int online, int max, String versionName) {
        if (s == null) {
            return "";
        }
        return s.replace("%%online%%", String.valueOf(online)).replace("%%max%%", String.valueOf(max)).replace("%%version%%", versionName == null ? "Minecraft" : versionName);
    }

    private String normalizeHex(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private String centerLines(String raw) {
        String[] arr = raw.split("\n", -1);
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            String line = arr[i];
            String visible = this.stripLegacy(line);
            int pad = Math.max(0, (50 - visible.length()) / 2);
            if (pad > 0) {
                out.append(" ".repeat(pad));
            }
            out.append(line);
            if (i >= arr.length - 1) continue;
            out.append("\n");
        }
        return out.toString();
    }

    private String stripLegacy(String s) {
        if (s == null) {
            return "";
        }
        String noHashHex = HEX_HASH.matcher(s).replaceAll("");
        return STRIP_LEGACY.matcher(noHashHex).replaceAll("");
    }
}

