/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.neverenoughanimations;

import com.cleanroommc.neverenoughanimations.NEAConfig;
import com.cleanroommc.neverenoughanimations.animations.ItemHoverAnimation;
import com.cleanroommc.neverenoughanimations.animations.ItemMoveAnimation;
import com.cleanroommc.neverenoughanimations.animations.ItemPickupThrowAnimation;
import com.cleanroommc.neverenoughanimations.animations.OpeningAnimation;
import com.cleanroommc.neverenoughanimations.api.IAnimatedScreen;
import com.cleanroommc.neverenoughanimations.api.IItemLocation;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Timer;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod(modid="neverenoughanimations", version="1.0.7", name="NeverEnoughAnimations", acceptedMinecraftVersions="[1.12.2]", clientSideOnly=true, dependencies="required:mixinbooter@[8.8,);")
public class NEA {
    public static final Logger LOGGER = LogManager.getLogger((String)"neverenoughanimations");
    private static boolean itemBordersLoaded = false;
    private static boolean jeiLoaded = false;
    private static boolean heiLoaded = false;
    private static GuiScreen currentDrawnScreen = null;
    private static float openAnimationValue = 1.0f;
    private static int mouseX;
    private static int mouseY;
    public static final Timer timer60Tps;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        itemBordersLoaded = Loader.isModLoaded((String)"itemborders");
        jeiLoaded = Loader.isModLoaded((String)"jei");
        if (jeiLoaded) {
            ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get("jei");
            heiLoaded = "Had Enough Items".equals(mod.getName());
        }
    }

    public static void onFrameTick() {
        OpeningAnimation.checkGuiToClose();
    }

    @SubscribeEvent
    public void onGuiTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        ItemHoverAnimation.onGuiTick();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.getModID().equals("neverenoughanimations")) {
            NEAConfig.blacklistCache.clear();
            ConfigManager.sync((String)"neverenoughanimations", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (OpeningAnimation.onGuiOpen(event)) {
            return;
        }
        ItemHoverAnimation.onGuiOpen(event);
        ItemMoveAnimation.onGuiOpen(event);
        ItemPickupThrowAnimation.onGuiOpen(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onGuiDrawPre(GuiScreenEvent.DrawScreenEvent.Pre event) {
        mouseX = event.getMouseX();
        mouseY = event.getMouseY();
        currentDrawnScreen = event.getGui();
        openAnimationValue = OpeningAnimation.getValue(currentDrawnScreen);
        if (NEAConfig.moveAnimationTime > 0 && event.getGui() instanceof IAnimatedScreen) {
            GlStateManager.pushMatrix();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiDrawPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        GuiScreen guiScreen;
        if (NEAConfig.moveAnimationTime > 0 && (guiScreen = event.getGui()) instanceof IAnimatedScreen) {
            IAnimatedScreen screen = (IAnimatedScreen)guiScreen;
            GlStateManager.popMatrix();
            OpeningAnimation.getScale(screen);
        }
        currentDrawnScreen = null;
        openAnimationValue = 1.0f;
    }

    @SubscribeEvent
    public void drawDebugInfo(GuiScreenEvent.BackgroundDrawnEvent event) {
        GuiScreen guiScreen = event.getGui();
        if (guiScreen instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)guiScreen;
            NEA.drawScreenDebug(container, event.getMouseX(), event.getMouseY());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiBackgroundDrawn(GuiScreenEvent.BackgroundDrawnEvent event) {
        if (NEAConfig.moveAnimationTime > 0) {
            OpeningAnimation.handleScale(event.getGui(), true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void mouseInput(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (OpeningAnimation.isAnimatingClose(event.getGui())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void mouseInput(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (OpeningAnimation.isAnimatingClose(event.getGui())) {
            event.setCanceled(true);
        }
    }

    public static int getMouseX() {
        return mouseX;
    }

    public static int getMouseY() {
        return mouseY;
    }

    @Nullable
    public static GuiScreen getCurrentDrawnScreen() {
        return currentDrawnScreen;
    }

    public static float getCurrentOpenAnimationValue() {
        return openAnimationValue;
    }

    public static boolean isCurrentGuiAnimating() {
        return currentDrawnScreen != null && openAnimationValue < 1.0f;
    }

    public static void drawScreenDebug(GuiContainer container, int mouseX, int mouseY) {
        if (!FMLLaunchHandler.isDeobfuscatedEnvironment() || container.getClass().getName().contains("modularui")) {
            return;
        }
        GlStateManager.disableDepth();
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        int screenH = container.height;
        int color = new Color(180, 40, 115).getRGB();
        int lineY = screenH - 13;
        FontRenderer fr = Minecraft.getMinecraft().fontRenderer;
        container.drawString(fr, "Mouse Pos: " + mouseX + ", " + mouseY, 5, lineY, color);
        container.drawString(fr, "Rel. Mouse Pos: " + (mouseX - container.getGuiLeft()) + ", " + (mouseY - container.getGuiTop()), 5, lineY -= 11, color);
        IItemLocation slot = IItemLocation.of(container.getSlotUnderMouse());
        if (slot != null) {
            container.drawString(fr, "Pos: " + slot.nea$getX() + ", " + slot.nea$getY(), 5, lineY -= 11, color);
            container.drawString(fr, "Class: " + slot.getClass().getSimpleName(), 5, lineY -= 11, color);
            container.drawString(fr, "Slot Number: " + slot.nea$getSlotNumber(), 5, lineY -= 11, color);
            lineY -= 11;
        }
        Gui.drawRect((int)mouseX, (int)mouseY, (int)(mouseX + 1), (int)(mouseY + 1), (int)new Color(10, 230, 10, 124).getRGB());
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableLighting();
        GlStateManager.enableDepth();
        GlStateManager.enableRescaleNormal();
        RenderHelper.enableStandardItemLighting();
    }

    public static boolean isItemBordersLoaded() {
        return itemBordersLoaded;
    }

    public static boolean isJeiLoaded() {
        return jeiLoaded;
    }

    public static boolean isHeiLoaded() {
        return heiLoaded;
    }

    public static long time() {
        return System.nanoTime() / 1000000L;
    }

    public static int getAlpha(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static int withAlpha(int argb, int alpha) {
        return (argb &= 0xFFFFFF) | alpha << 24;
    }

    public static int withAlpha(int argb, float alpha) {
        return NEA.withAlpha(argb, (int)(alpha * 255.0f));
    }

    public static void onContainerClosed(EntityPlayer player) {
        InventoryPlayer inventoryplayer = player.inventory;
        if (!inventoryplayer.getItemStack().isEmpty()) {
            player.dropItem(inventoryplayer.getItemStack(), false);
            inventoryplayer.setItemStack(ItemStack.EMPTY);
        }
    }

    static {
        timer60Tps = new Timer(60.0f);
    }
}

