/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.neverenoughanimations.animations;

import com.cleanroommc.neverenoughanimations.NEA;
import com.cleanroommc.neverenoughanimations.NEAConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;

public class HotbarAnimation {
    private static int oldIndex = -1;
    private static int newIndex = -1;
    private static int fromX = -1;
    private static int currentX = -1;
    private static long startTime = 0L;

    public static void animate(int oldIndex, int newIndex) {
        if (NEAConfig.hotbarAnimationTime == 0) {
            return;
        }
        if (HotbarAnimation.isAnimationInProgress()) {
            fromX = currentX;
        } else {
            HotbarAnimation.oldIndex = oldIndex;
        }
        HotbarAnimation.newIndex = newIndex;
        if (HotbarAnimation.oldIndex == HotbarAnimation.newIndex) {
            HotbarAnimation.reset();
            return;
        }
        startTime = NEA.time();
    }

    public static boolean isAnimationInProgress() {
        return oldIndex >= 0;
    }

    public static void reset() {
        oldIndex = -1;
        newIndex = -1;
        fromX = -1;
        currentX = -1;
    }

    public static int getX(ScaledResolution sr) {
        int def = Minecraft.getMinecraft().player.inventory.currentItem;
        if (NEAConfig.hotbarAnimationTime == 0 || oldIndex < 0 || newIndex < 0) {
            return HotbarAnimation.getX(sr, def);
        }
        if (def != newIndex) {
            HotbarAnimation.reset();
            return HotbarAnimation.getX(sr, def);
        }
        float val = (float)(NEA.time() - startTime) / (float)NEAConfig.hotbarAnimationTime;
        if (val >= 1.0f) {
            HotbarAnimation.reset();
            return HotbarAnimation.getX(sr, def);
        }
        if (fromX < 0) {
            fromX = HotbarAnimation.getX(sr, oldIndex);
        }
        currentX = (int)NEAConfig.hotbarAnimationCurve.interpolate(fromX, HotbarAnimation.getX(sr, newIndex), val);
        return currentX;
    }

    public static int getX(ScaledResolution sr, int index) {
        return sr.getScaledWidth() / 2 - 91 - 1 + index * 20;
    }
}

