/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.neverenoughanimations.animations;

import com.cleanroommc.neverenoughanimations.NEA;
import com.cleanroommc.neverenoughanimations.NEAConfig;
import com.cleanroommc.neverenoughanimations.api.IItemLocation;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiOpenEvent;
import org.jetbrains.annotations.ApiStatus;

public class ItemPickupThrowAnimation {
    private static final Object2LongOpenHashMap<IItemLocation> animated = new Object2LongOpenHashMap();
    private static final List<IItemLocation> removalAnimation = new ArrayList<IItemLocation>();
    private static GuiContainer lastGui;

    @ApiStatus.Internal
    public static void onGuiOpen(GuiOpenEvent event) {
        if (NEAConfig.hoverAnimationTime > 0) {
            if (!(event.getGui() instanceof GuiContainer)) {
                if (lastGui != null) {
                    lastGui = null;
                    animated.clear();
                }
                return;
            }
            if (!NEAConfig.isBlacklisted(event.getGui())) {
                lastGui = (GuiContainer)event.getGui();
                animated.clear();
            }
        }
    }

    public static void animate(Slot slot) {
        if (lastGui == null) {
            return;
        }
        ItemPickupThrowAnimation.animate(IItemLocation.of(slot));
    }

    public static void animate(IItemLocation slot) {
        if (lastGui == null) {
            return;
        }
        animated.put((Object)slot, NEA.time());
        if (slot.nea$getSlotNumber() < 0) {
            removalAnimation.add(slot);
        }
    }

    public static void animate(int x, int y, ItemStack stack, boolean absolutePos) {
        if (lastGui == null) {
            return;
        }
        if (absolutePos) {
            x -= lastGui.getGuiLeft();
            y -= lastGui.getGuiTop();
        }
        ItemPickupThrowAnimation.animate(new IItemLocation.Impl(x, y, stack));
    }

    public static float getValue(GuiContainer container, Slot slot) {
        return ItemPickupThrowAnimation.getValue(container, IItemLocation.of(slot));
    }

    public static float getValue(GuiContainer container, IItemLocation slot) {
        if (lastGui != container || !animated.containsKey((Object)slot)) {
            return 1.0f;
        }
        long time = animated.getLong((Object)slot);
        float val = (float)(NEA.time() - time) / (float)NEAConfig.appearAnimationTime;
        if (val >= 1.0f) {
            animated.removeLong((Object)slot);
            return 1.0f;
        }
        return NEAConfig.appearAnimationCurve.interpolate(0.0f, 1.0f, val);
    }

    public static void drawIndependentAnimations(GuiContainer container, RenderItem itemRender, FontRenderer fontRenderer) {
        int n = removalAnimation.size();
        for (int i = 0; i < n; ++i) {
            IItemLocation slot = removalAnimation.get(i);
            int x = slot.nea$getX();
            int y = slot.nea$getY();
            float value = 1.0f - ItemPickupThrowAnimation.getValue(container, slot);
            if (value <= 0.0f) {
                removalAnimation.remove(i);
                --i;
                --n;
                continue;
            }
            GlStateManager.translate((float)x, (float)y, (float)0.0f);
            if (value <= 1.0f) {
                GlStateManager.pushMatrix();
                GlStateManager.translate((float)8.0f, (float)8.0f, (float)0.0f);
                GlStateManager.scale((float)value, (float)value, (float)1.0f);
                GlStateManager.translate((float)-8.0f, (float)-8.0f, (float)0.0f);
            } else if (!animated.containsKey((Object)slot)) {
                removalAnimation.remove(i);
                --i;
                --n;
                GlStateManager.translate((float)(-x), (float)(-y), (float)0.0f);
                continue;
            }
            GlStateManager.translate((float)0.0f, (float)0.0f, (float)32.0f);
            FontRenderer font = slot.nea$getStack().getItem().getFontRenderer(slot.nea$getStack());
            if (font == null) {
                font = fontRenderer;
            }
            itemRender.renderItemAndEffectIntoGUI((EntityLivingBase)Minecraft.getMinecraft().player, slot.nea$getStack(), 0, 0);
            itemRender.renderItemOverlayIntoGUI(font, slot.nea$getStack(), 0, 0, null);
            if (value <= 1.0f) {
                GlStateManager.popMatrix();
            }
            GlStateManager.translate((float)(-x), (float)(-y), (float)0.0f);
        }
    }
}

