/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.neverenoughanimations.animations;

import com.cleanroommc.neverenoughanimations.NEA;
import com.cleanroommc.neverenoughanimations.NEAConfig;
import com.cleanroommc.neverenoughanimations.api.IAnimatedScreen;
import com.cleanroommc.neverenoughanimations.util.Interpolations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.event.GuiOpenEvent;

public class OpeningAnimation {
    private static IAnimatedScreen lastGui;
    private static IAnimatedScreen animatedGui;
    private static long startTime;
    private static boolean shouldCloseLast;

    public static boolean onGuiOpen(GuiOpenEvent event) {
        if (OpeningAnimation.onGuiOpen(event.getGui())) {
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    public static boolean onGuiOpen(GuiScreen screen) {
        if (screen instanceof IAnimatedScreen) {
            IAnimatedScreen animatedScreen = (IAnimatedScreen)screen;
            if (Minecraft.getMinecraft().currentScreen == null) {
                OpeningAnimation.animate(animatedScreen, true);
            }
        } else if (Minecraft.getMinecraft().currentScreen == lastGui && screen == null && !shouldCloseLast) {
            if (animatedGui == null || OpeningAnimation.getValue(animatedGui) >= 1.0f || startTime > 0L) {
                OpeningAnimation.animate(lastGui, false);
            }
            return true;
        }
        return false;
    }

    public static void animate(IAnimatedScreen container, boolean open) {
        if (NEAConfig.openingAnimationTime == 0 || NEAConfig.isBlacklisted(container)) {
            return;
        }
        animatedGui = container;
        lastGui = container;
        startTime = NEA.time();
        if (!open) {
            startTime = -startTime;
            Minecraft.getMinecraft().setIngameFocus();
        }
    }

    public static float getScale(GuiScreen screen) {
        float f;
        if (screen instanceof IAnimatedScreen) {
            IAnimatedScreen animatedScreen = (IAnimatedScreen)screen;
            f = OpeningAnimation.getScale(animatedScreen);
        } else {
            f = 1.0f;
        }
        return f;
    }

    public static float getScale(IAnimatedScreen container) {
        float min = NEAConfig.openingStartScale;
        float max = 1.0f;
        return Interpolations.lerp(min, max, OpeningAnimation.getValue(container));
    }

    public static float getValue(GuiScreen screen) {
        float f;
        if (screen instanceof IAnimatedScreen) {
            IAnimatedScreen animatedScreen = (IAnimatedScreen)screen;
            f = OpeningAnimation.getValue(animatedScreen);
        } else {
            f = 1.0f;
        }
        return f;
    }

    public static float getValue(IAnimatedScreen container) {
        if (shouldCloseLast) {
            return 0.001f;
        }
        if (animatedGui != container) {
            return 1.0f;
        }
        float val = (float)(NEA.time() - Math.abs(startTime)) / (float)NEAConfig.openingAnimationTime;
        if (startTime < 0L) {
            if ((val = 1.0f - val) <= 0.0f) {
                animatedGui = null;
                shouldCloseLast = true;
                return 0.0f;
            }
        } else if (val >= 1.0f) {
            animatedGui = null;
            return 1.0f;
        }
        return NEAConfig.openingAnimationCurve.interpolate(0.0f, 1.0f, val);
    }

    public static boolean handleScale(GuiScreen screen, boolean translateToPanel) {
        IAnimatedScreen animatedScreen;
        return screen instanceof IAnimatedScreen && OpeningAnimation.handleScale(animatedScreen = (IAnimatedScreen)screen, translateToPanel);
    }

    public static boolean handleScale(IAnimatedScreen screen, boolean translateToPanel) {
        float scale = OpeningAnimation.getScale(screen);
        if (scale == 1.0f || NEAConfig.moveAnimationTime == 0) {
            return false;
        }
        if (translateToPanel) {
            GlStateManager.translate((float)screen.nea$getX(), (float)screen.nea$getY(), (float)0.0f);
        }
        GlStateManager.translate((float)((float)screen.nea$getWidth() / 2.0f), (float)((float)screen.nea$getHeight() / 2.0f), (float)0.0f);
        GlStateManager.scale((float)scale, (float)scale, (float)1.0f);
        GlStateManager.translate((float)((float)(-screen.nea$getWidth()) / 2.0f), (float)((float)(-screen.nea$getHeight()) / 2.0f), (float)0.0f);
        if (translateToPanel) {
            GlStateManager.translate((float)(-screen.nea$getX()), (float)(-screen.nea$getY()), (float)0.0f);
        }
        return true;
    }

    public static boolean isAnimating(GuiScreen screen) {
        IAnimatedScreen animatedScreen;
        return screen instanceof IAnimatedScreen && OpeningAnimation.isAnimating(animatedScreen = (IAnimatedScreen)screen);
    }

    public static boolean isAnimating(IAnimatedScreen screen) {
        return OpeningAnimation.getValue(screen) < 1.0f;
    }

    public static boolean isAnimatingClose(GuiScreen screen) {
        IAnimatedScreen animatedScreen;
        return screen instanceof IAnimatedScreen && OpeningAnimation.isAnimatingClose(animatedScreen = (IAnimatedScreen)screen);
    }

    public static boolean isAnimatingClose(IAnimatedScreen screen) {
        return OpeningAnimation.isAnimating(screen) && startTime < 0L;
    }

    public static void checkGuiToClose() {
        if (shouldCloseLast && lastGui != null) {
            Minecraft.getMinecraft().displayGuiScreen(null);
            shouldCloseLast = false;
            lastGui = null;
        }
    }

    static {
        startTime = 0L;
        shouldCloseLast = false;
    }
}

