/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.neverenoughanimations.api;

import com.cleanroommc.neverenoughanimations.NEA;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public interface IItemLocation {
    public static final IItemLocation CURSOR = new IItemLocation(){

        @Override
        public int nea$getX() {
            int guiX = 0;
            GuiScreen guiScreen = Minecraft.getMinecraft().currentScreen;
            if (guiScreen instanceof GuiContainer) {
                GuiContainer container = (GuiContainer)guiScreen;
                guiX = container.getGuiLeft();
            }
            return NEA.getMouseX() - 8 - guiX;
        }

        @Override
        public int nea$getY() {
            int guiY = 0;
            GuiScreen guiScreen = Minecraft.getMinecraft().currentScreen;
            if (guiScreen instanceof GuiContainer) {
                GuiContainer container = (GuiContainer)guiScreen;
                guiY = container.getGuiTop();
            }
            return NEA.getMouseY() - 8 - guiY;
        }

        @Override
        public int nea$getSlotNumber() {
            return -1;
        }

        @Override
        public ItemStack nea$getStack() {
            return Minecraft.getMinecraft().player.inventory.getItemStack();
        }
    };

    public static IItemLocation of(Slot slot) {
        return (IItemLocation)slot;
    }

    public int nea$getX();

    public int nea$getY();

    public int nea$getSlotNumber();

    public ItemStack nea$getStack();

    public static class Impl
    implements IItemLocation {
        private final int x;
        private final int y;
        private final int slotNumber;
        private final ItemStack stack;

        public Impl(int x, int y, ItemStack stack) {
            this(x, y, -2, stack);
        }

        public Impl(int x, int y, int slotNumber, ItemStack stack) {
            this.x = x;
            this.y = y;
            this.slotNumber = slotNumber;
            this.stack = stack;
        }

        @Override
        public int nea$getX() {
            return this.x;
        }

        @Override
        public int nea$getY() {
            return this.y;
        }

        @Override
        public int nea$getSlotNumber() {
            return this.slotNumber;
        }

        @Override
        public ItemStack nea$getStack() {
            return this.stack;
        }
    }
}

