/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.neverenoughanimations.core.mixin;

import com.cleanroommc.neverenoughanimations.NEA;
import com.cleanroommc.neverenoughanimations.NEAConfig;
import com.cleanroommc.neverenoughanimations.animations.ItemHoverAnimation;
import com.cleanroommc.neverenoughanimations.animations.ItemMoveAnimation;
import com.cleanroommc.neverenoughanimations.animations.ItemPickupThrowAnimation;
import com.cleanroommc.neverenoughanimations.api.IAnimatedScreen;
import com.cleanroommc.neverenoughanimations.api.IItemLocation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiContainer.class}, priority=950)
public abstract class GuiContainerMixin
extends GuiScreen
implements IAnimatedScreen {
    @Shadow(remap=false)
    public abstract int getGuiLeft();

    @Shadow(remap=false)
    public abstract int getGuiTop();

    @Shadow(remap=false)
    public abstract int getXSize();

    @Shadow(remap=false)
    public abstract int getYSize();

    @Inject(method={"drawSlot"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isEmpty()Z", ordinal=5, shift=At.Shift.BEFORE)})
    public void injectVirtualStack(Slot slotIn, CallbackInfo ci, @Local(ordinal=0) LocalRef<ItemStack> itemStack) {
        ItemStack virtualStack;
        if (NEAConfig.moveAnimationTime > 0 && (virtualStack = ItemMoveAnimation.getVirtualStack((GuiContainer)this, slotIn)) != null) {
            itemStack.set((Object)virtualStack);
        }
    }

    @Inject(method={"drawSlot"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderItem;renderItemAndEffectIntoGUI(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;II)V", shift=At.Shift.BEFORE)})
    public void injectHoverScale(Slot slotIn, CallbackInfo ci, @Share(value="scale") LocalFloatRef scaleRef) {
        if (NEAConfig.hoverAnimationTime > 0) {
            GlStateManager.pushMatrix();
            float scale = ItemHoverAnimation.getRenderScale((GuiContainer)this, slotIn);
            scaleRef.set(scale);
            if (scale > 1.0f) {
                int x = slotIn.xPos + 8;
                int y = slotIn.yPos + 8;
                GlStateManager.translate((float)x, (float)y, (float)0.0f);
                GlStateManager.scale((float)scale, (float)scale, (float)1.0f);
                GlStateManager.translate((float)(-x), (float)(-y), (float)0.0f);
            }
        }
    }

    @Inject(method={"drawSlot"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderItem;renderItemAndEffectIntoGUI(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;II)V", shift=At.Shift.AFTER)})
    public void midHoverScale(Slot slotIn, CallbackInfo ci) {
        if (NEA.isItemBordersLoaded() && NEAConfig.hoverAnimationTime > 0) {
            GlStateManager.popMatrix();
        }
    }

    @Inject(method={"drawSlot"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderItem;renderItemOverlayIntoGUI(Lnet/minecraft/client/gui/FontRenderer;Lnet/minecraft/item/ItemStack;IILjava/lang/String;)V", shift=At.Shift.AFTER)})
    public void endHoverScale(Slot slotIn, CallbackInfo ci, @Share(value="scale") LocalFloatRef scaleRef) {
        if (NEAConfig.hoverAnimationTime == 0) {
            return;
        }
        if (NEA.isItemBordersLoaded()) {
            GlStateManager.pushMatrix();
            float scale = scaleRef.get();
            if (scale > 1.0f) {
                int x = slotIn.xPos + 8;
                int y = slotIn.yPos + 8;
                GlStateManager.translate((float)x, (float)y, (float)0.0f);
                GlStateManager.scale((float)scale, (float)scale, (float)1.0f);
                GlStateManager.translate((float)(-x), (float)(-y), (float)0.0f);
            }
        }
        GlStateManager.popMatrix();
    }

    @Redirect(method={"drawScreen"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/inventory/GuiContainer;drawGradientRect(IIIIII)V"))
    public void dontDrawOverlay(GuiContainer instance, int i1, int i2, int i3, int i4, int i5, int i6) {
        if (NEAConfig.itemHoverOverlay) {
            this.drawGradientRect(i1, i2, i3, i4, i5, i6);
        }
    }

    @Inject(method={"drawScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GlStateManager;popMatrix()V", shift=At.Shift.BEFORE)})
    public void drawMovingItems(int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        this.zLevel = 200.0f;
        this.itemRender.zLevel = 200.0f;
        ItemPickupThrowAnimation.drawIndependentAnimations((GuiContainer)this, this.itemRender, this.fontRenderer);
        ItemMoveAnimation.drawAnimations(this.itemRender, this.fontRenderer);
        this.itemRender.zLevel = 0.0f;
        this.zLevel = 0.0f;
    }

    @ModifyArg(method={"drawScreen"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/inventory/GuiContainer;drawItemStack(Lnet/minecraft/item/ItemStack;IILjava/lang/String;)V", ordinal=0), index=0)
    public ItemStack injectVirtualCursorStack(ItemStack stack) {
        if (NEAConfig.moveAnimationTime > 0) {
            ItemStack virtual = ItemMoveAnimation.getVirtualStack((GuiContainer)this, IItemLocation.CURSOR);
            return virtual == null ? stack : virtual;
        }
        return stack;
    }

    @Override
    public int nea$getX() {
        return this.getGuiLeft();
    }

    @Override
    public int nea$getY() {
        return this.getGuiTop();
    }

    @Override
    public int nea$getWidth() {
        return this.getXSize();
    }

    @Override
    public int nea$getHeight() {
        return this.getYSize();
    }
}

