/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.neverenoughanimations.animations;

import com.cleanroommc.neverenoughanimations.NEA;
import com.cleanroommc.neverenoughanimations.NEAConfig;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;

@SideOnly(value=Side.CLIENT)
public class ItemHoverAnimation {
    private static GuiContainer lastHoveredGui = null;
    private static Slot lastHoveredSlot = null;
    private static final Object2LongOpenHashMap<Slot> hoveredSlots = new Object2LongOpenHashMap(32);

    @ApiStatus.Internal
    public static void onGuiOpen(GuiOpenEvent event) {
        if (NEAConfig.hoverAnimationTime > 0) {
            if (!(event.getGui() instanceof GuiContainer)) {
                if (lastHoveredGui != null) {
                    lastHoveredGui = null;
                    lastHoveredSlot = null;
                    hoveredSlots.clear();
                }
                return;
            }
            if (!NEAConfig.isBlacklisted(event.getGui())) {
                lastHoveredGui = (GuiContainer)event.getGui();
                lastHoveredSlot = null;
                hoveredSlots.clear();
            }
        }
    }

    private static void startAnimation(Slot slot, boolean grow) {
        hoveredSlots.put((Object)slot, NEA.time() * (long)(grow ? 1 : -1));
    }

    public static boolean isAnimating(Slot slot) {
        return hoveredSlots.containsKey((Object)slot);
    }

    @ApiStatus.Internal
    public static void onGuiTick() {
        if (NEAConfig.hoverAnimationTime == 0 || lastHoveredGui == null) {
            return;
        }
        Slot hoveredSlot = lastHoveredGui.getSlotUnderMouse();
        if (lastHoveredSlot != null && (hoveredSlot == null || hoveredSlot != lastHoveredSlot)) {
            ItemHoverAnimation.startAnimation(lastHoveredSlot, false);
        }
        if (hoveredSlot != null) {
            lastHoveredSlot = hoveredSlot;
            if (!ItemHoverAnimation.isAnimating(hoveredSlot)) {
                ItemHoverAnimation.startAnimation(hoveredSlot, true);
            }
        } else {
            lastHoveredSlot = null;
        }
    }

    public static float getRenderScale(GuiContainer gui, Slot slot) {
        if (lastHoveredGui != gui || !ItemHoverAnimation.isAnimating(slot) || NEAConfig.isBlacklisted(gui)) {
            return 1.0f;
        }
        float min = 1.0f;
        float max = 1.25f;
        long slotTime = hoveredSlots.getLong((Object)slot);
        float val = (float)(NEA.time() - Math.abs(slotTime)) / (float)NEAConfig.hoverAnimationTime;
        if (slotTime < 0L) {
            if ((val = 1.0f - val) <= 0.0f) {
                hoveredSlots.removeLong((Object)slot);
                return 1.0f;
            }
        } else if (val >= 1.0f) {
            return max;
        }
        return NEAConfig.hoverAnimationCurve.interpolate(min, max, val);
    }
}

