/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.neverenoughanimations.animations;

import com.cleanroommc.neverenoughanimations.NEA;
import com.cleanroommc.neverenoughanimations.NEAConfig;
import com.cleanroommc.neverenoughanimations.animations.ItemMovePacket;
import com.cleanroommc.neverenoughanimations.api.IItemLocation;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

@SideOnly(value=Side.CLIENT)
public class ItemMoveAnimation {
    private static final Int2ObjectOpenHashMap<List<ItemMovePacket>> movingItemsBySource = new Int2ObjectOpenHashMap();
    private static GuiContainer lastGui = null;
    private static final ObjectArrayList<ItemStack> virtualStacks = new ObjectArrayList(256);
    private static final IntArrayList virtualStacksUser = new IntArrayList(256);
    private static long lastAnimation = 0L;

    @ApiStatus.Internal
    public static void onGuiOpen(GuiOpenEvent event) {
        if (NEAConfig.moveAnimationTime == 0) {
            return;
        }
        if (!(event.getGui() instanceof GuiContainer)) {
            if (lastGui != null) {
                lastGui = null;
                movingItemsBySource.clear();
            }
            return;
        }
        if (!NEAConfig.isBlacklisted(event.getGui())) {
            lastGui = (GuiContainer)event.getGui();
            movingItemsBySource.clear();
            virtualStacks.clear();
            virtualStacksUser.clear();
        }
    }

    public static ItemStack getVirtualStack(GuiContainer container, Slot slot) {
        return ItemMoveAnimation.getVirtualStack(container, IItemLocation.of(slot));
    }

    public static ItemStack getVirtualStack(GuiContainer container, IItemLocation slot) {
        return container == lastGui && !NEAConfig.isBlacklisted(container) && virtualStacks.size() > slot.nea$getSlotNumber() + 1 && virtualStacksUser.getInt(slot.nea$getSlotNumber() + 1) > 0 ? (ItemStack)virtualStacks.get(slot.nea$getSlotNumber() + 1) : null;
    }

    @ApiStatus.Internal
    public static void updateVirtualStack(int target, ItemStack stack, int op) {
        if (NEAConfig.moveAnimationTime == 0) {
            return;
        }
        while (target + 1 >= virtualStacks.size()) {
            virtualStacks.add(null);
            virtualStacksUser.add(0);
        }
        int users = virtualStacksUser.getInt(target + 1) + op;
        if (users <= 0) {
            stack = null;
            users = 0;
        }
        virtualStacks.set(target + 1, (Object)stack);
        virtualStacksUser.set(target + 1, users);
    }

    public static void queueAnimation(int slot, ItemMovePacket packet) {
        ArrayList<ItemMovePacket> packets = (ArrayList<ItemMovePacket>)movingItemsBySource.get(slot + 1);
        if (packets == null) {
            packets = new ArrayList<ItemMovePacket>();
            movingItemsBySource.put(slot + 1, packets);
        }
        packets.add(packet);
    }

    public static void queueAnimation(int slot, List<ItemMovePacket> packet) {
        ArrayList<ItemMovePacket> packets = (ArrayList<ItemMovePacket>)movingItemsBySource.get(slot + 1);
        if (packets == null) {
            packets = new ArrayList<ItemMovePacket>();
            movingItemsBySource.put(slot + 1, packets);
        }
        packets.addAll(packet);
    }

    @ApiStatus.Internal
    public static Pair<List<Slot>, List<ItemStack>> getCandidates(Slot in, List<Slot> allSlots) {
        if (NEAConfig.moveAnimationTime == 0 || NEAConfig.isBlacklisted(Minecraft.func_71410_x().field_71462_r) || NEA.time() - lastAnimation <= 10L) {
            return null;
        }
        ArrayList<Slot> slots = new ArrayList<Slot>(allSlots.size());
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(allSlots.size());
        ItemStack item = IItemLocation.of(in).nea$getStack();
        for (Slot slot : allSlots) {
            if (in == slot) continue;
            ItemStack other = slot.func_75211_c();
            if (other.func_190926_b()) {
                slots.add(slot);
                stacks.add(ItemStack.field_190927_a);
                continue;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)item, (ItemStack)other)) continue;
            slots.add(slot);
            stacks.add(other.func_77946_l());
        }
        return Pair.of(slots, stacks);
    }

    @ApiStatus.Internal
    public static void handleMove(Slot source, ItemStack oldSource, Pair<List<Slot>, List<ItemStack>> candidates) {
        IItemLocation sourceLoc = IItemLocation.of(source);
        List slots = (List)candidates.getLeft();
        List stacks = (List)candidates.getRight();
        int total = oldSource.func_190916_E() - source.func_75211_c().func_190916_E();
        if (total <= 0) {
            return;
        }
        ArrayList<ItemMovePacket> packets = new ArrayList<ItemMovePacket>();
        Int2ObjectArrayMap stagedVirtualStacks = new Int2ObjectArrayMap();
        boolean error = false;
        long time = NEA.time();
        for (int i = 0; i < slots.size(); ++i) {
            IItemLocation slot = IItemLocation.of((Slot)slots.get(i));
            if (slot == sourceLoc) continue;
            ItemStack oldStack = (ItemStack)stacks.get(i);
            ItemStack newStack = slot.nea$getStack();
            if (oldStack.func_190926_b()) {
                if (!newStack.func_190926_b()) {
                    ItemMovePacket packet = new ItemMovePacket(time, sourceLoc, slot, newStack.func_77946_l());
                    packets.add(packet);
                    total -= newStack.func_190916_E();
                    stagedVirtualStacks.put(slot.nea$getSlotNumber(), (Object)oldStack);
                }
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)newStack, (ItemStack)oldStack)) {
                if (oldStack.func_190916_E() < newStack.func_190916_E()) {
                    ItemStack movingStack = newStack.func_77946_l();
                    movingStack.func_190918_g(oldStack.func_190916_E());
                    ItemMovePacket packet = new ItemMovePacket(time, sourceLoc, slot, movingStack);
                    packets.add(packet);
                    total -= movingStack.func_190916_E();
                    stagedVirtualStacks.put(slot.nea$getSlotNumber(), (Object)oldStack);
                } else if (oldStack.func_190916_E() > newStack.func_190916_E()) {
                    NEA.LOGGER.error("After shift clicking a target slot ({}) now has less items than before!", (Object)slot.nea$getSlotNumber());
                    error = true;
                }
            } else {
                NEA.LOGGER.error("After shift clicking a target slot ({}) now has a different item than before!", (Object)slot.nea$getSlotNumber());
                error = true;
            }
            if (total <= 0) break;
        }
        if (total < 0) {
            NEA.LOGGER.error("The original stack had {} items, but {} items where moved!", (Object)oldSource.func_190916_E(), (Object)(oldSource.func_190916_E() - total));
        }
        if (error || packets.isEmpty()) {
            return;
        }
        ItemMoveAnimation.queueAnimation(sourceLoc.nea$getSlotNumber(), packets);
        ObjectIterator iterator = stagedVirtualStacks.int2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Int2ObjectMap.Entry e = (Int2ObjectMap.Entry)iterator.next();
            ItemMoveAnimation.updateVirtualStack(e.getIntKey(), (ItemStack)e.getValue(), 1);
        }
        lastAnimation = NEA.time();
    }

    public static void drawAnimations() {
        ItemMoveAnimation.drawAnimations(Minecraft.func_71410_x().func_175599_af(), Minecraft.func_71410_x().field_71466_p);
    }

    public static void drawAnimations(RenderItem itemRender, FontRenderer fontRenderer) {
        ObjectIterator iter = movingItemsBySource.values().iterator();
        while (iter.hasNext()) {
            List packets = (List)iter.next();
            Iterator iterator = packets.iterator();
            while (iterator.hasNext()) {
                ItemMovePacket packet = (ItemMovePacket)iterator.next();
                boolean end = false;
                float val = packet.value();
                if (val >= 1.0f) {
                    val = 1.0f;
                    end = true;
                }
                int x = packet.getDrawX(val);
                int y = packet.getDrawY(val);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
                FontRenderer font = packet.getMovingStack().func_77973_b().getFontRenderer(packet.getMovingStack());
                if (font == null) {
                    font = fontRenderer;
                }
                itemRender.func_184391_a((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, packet.getMovingStack(), x, y);
                itemRender.func_180453_a(font, packet.getMovingStack(), x, y, null);
                if (!end) continue;
                ItemMoveAnimation.updateVirtualStack(packet.getTarget().nea$getSlotNumber(), packet.getTargetStack(), -1);
                if (packets.size() == 1) {
                    iter.remove();
                    break;
                }
                iterator.remove();
            }
            if (!packets.isEmpty()) continue;
            iter.remove();
        }
    }
}

