/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.neverenoughanimations.animations;

import com.cleanroommc.neverenoughanimations.NEA;
import com.cleanroommc.neverenoughanimations.NEAConfig;
import com.cleanroommc.neverenoughanimations.api.IItemLocation;
import net.minecraft.item.ItemStack;

public class ItemMovePacket {
    private final long time;
    private final IItemLocation source;
    private final IItemLocation target;
    private final ItemStack movingStack;
    private final ItemStack targetStack;

    public ItemMovePacket(long time, IItemLocation source, IItemLocation target, ItemStack movingStack) {
        this.time = time;
        this.source = source;
        this.target = target;
        this.targetStack = target.nea$getStack().func_77946_l();
        this.movingStack = movingStack;
    }

    public long getTime() {
        return this.time;
    }

    public ItemStack getMovingStack() {
        return this.movingStack;
    }

    public ItemStack getTargetStack() {
        return this.targetStack;
    }

    public IItemLocation getSource() {
        return this.source;
    }

    public IItemLocation getTarget() {
        return this.target;
    }

    public float value() {
        return Math.min(1.0f, (float)(NEA.time() - this.time) / (float)NEAConfig.moveAnimationTime);
    }

    public int getDrawX(float value) {
        return (int)NEAConfig.moveAnimationCurve.interpolate(this.source.nea$getX(), this.target.nea$getX(), value);
    }

    public int getDrawY(float value) {
        return (int)NEAConfig.moveAnimationCurve.interpolate(this.source.nea$getY(), this.target.nea$getY(), value);
    }
}

