/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.neverenoughanimations.animations;

import com.cleanroommc.neverenoughanimations.NEA;
import com.cleanroommc.neverenoughanimations.NEAConfig;
import com.cleanroommc.neverenoughanimations.animations.ItemMoveAnimation;
import com.cleanroommc.neverenoughanimations.animations.ItemMovePacket;
import com.cleanroommc.neverenoughanimations.api.IItemLocation;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class SwapHolder {
    public static final SwapHolder INSTANCE = new SwapHolder();
    private Slot targetSlot;
    private Slot hotbarSlot;
    private ItemStack targetStack;
    private ItemStack hotbarStack;

    public boolean init(Slot hoveredSlot, List<Slot> slots, int hotbarIndex) {
        if (NEAConfig.isBlacklisted(Minecraft.func_71410_x().field_71462_r)) {
            return false;
        }
        this.targetSlot = hoveredSlot;
        this.hotbarSlot = SwapHolder.findHotbarSlot(slots, hotbarIndex);
        if (this.hotbarSlot == null) {
            this.reset();
            return false;
        }
        this.targetStack = this.targetSlot.func_75211_c();
        this.hotbarStack = this.hotbarSlot.func_75211_c();
        if (this.targetStack.func_190926_b() && this.hotbarStack.func_190926_b()) {
            this.reset();
            return false;
        }
        this.targetStack = this.targetStack.func_77946_l();
        this.hotbarStack = this.hotbarStack.func_77946_l();
        return true;
    }

    public void performSwap() {
        if (this.hotbarSlot == null || this.targetSlot == null || this.hotbarStack == null || this.targetStack == null) {
            this.reset();
            return;
        }
        IItemLocation hotbar = IItemLocation.of(this.hotbarSlot);
        IItemLocation hovering = IItemLocation.of(this.targetSlot);
        long time = NEA.time();
        if (this.targetStack.func_190926_b()) {
            if (!hovering.nea$getStack().func_190926_b()) {
                ItemMoveAnimation.queueAnimation(hotbar.nea$getSlotNumber(), new ItemMovePacket(time, hotbar, hovering, hovering.nea$getStack().func_77946_l()));
                ItemMoveAnimation.updateVirtualStack(hovering.nea$getSlotNumber(), ItemStack.field_190927_a, 1);
            }
        } else if (this.hotbarStack.func_190926_b()) {
            if (!hotbar.nea$getStack().func_190926_b()) {
                ItemMoveAnimation.queueAnimation(hovering.nea$getSlotNumber(), new ItemMovePacket(time, hovering, hotbar, hotbar.nea$getStack().func_77946_l()));
                ItemMoveAnimation.updateVirtualStack(hotbar.nea$getSlotNumber(), ItemStack.field_190927_a, 1);
            }
        } else {
            ItemMoveAnimation.queueAnimation(hotbar.nea$getSlotNumber(), new ItemMovePacket(time, hotbar, hovering, hovering.nea$getStack().func_77946_l()));
            ItemMoveAnimation.queueAnimation(hovering.nea$getSlotNumber(), new ItemMovePacket(time, hovering, hotbar, hotbar.nea$getStack().func_77946_l()));
            ItemMoveAnimation.updateVirtualStack(hovering.nea$getSlotNumber(), ItemStack.field_190927_a, 1);
            ItemMoveAnimation.updateVirtualStack(hotbar.nea$getSlotNumber(), ItemStack.field_190927_a, 1);
        }
        this.reset();
    }

    public void reset() {
        this.targetSlot = null;
        this.hotbarSlot = null;
        this.targetStack = null;
        this.hotbarStack = null;
    }

    public ItemStack getTargetStack() {
        return this.targetStack;
    }

    public ItemStack getHotbarStack() {
        return this.hotbarStack;
    }

    public Slot getHotbarSlot() {
        return this.hotbarSlot;
    }

    public Slot getTargetSlot() {
        return this.targetSlot;
    }

    public static Slot findHotbarSlot(List<Slot> slots, int index) {
        for (Slot slot : slots) {
            SlotItemHandler slotItemHandler;
            if (slot.getSlotIndex() != index || !(slot.field_75224_c instanceof InventoryPlayer) && (!(slot instanceof SlotItemHandler) || !((slotItemHandler = (SlotItemHandler)slot).getItemHandler() instanceof PlayerMainInvWrapper) && !(slotItemHandler.getItemHandler() instanceof PlayerInvWrapper))) continue;
            return slot;
        }
        return null;
    }
}

