/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.locator_lodestones;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_11200;
import net.minecraft.class_11208;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import net.minecraft.class_9276;
import net.minecraft.class_9291;
import net.minecraft.class_9334;
import net.pneumono.locator_lodestones.ColorHandler;
import net.pneumono.locator_lodestones.LocatorLodestones;
import net.pneumono.locator_lodestones.config.ConfigManager;

public class WaypointTracking {
    public static final Map<Either<UUID, String>, Optional<class_2561>> WAYPOINT_NAMES = new HashMap<Either<UUID, String>, Optional<class_2561>>();
    protected static final List<class_11200> CURRENT_WAYPOINTS = new ArrayList<class_11200>();
    private static final List<class_11200> PREVIOUS_WAYPOINTS = new ArrayList<class_11200>();
    private static long lastUpdateTime = 0L;

    public static void updateWaypoints(class_746 player) {
        boolean isTracked;
        if (lastUpdateTime + 20L > (long)player.field_6012 && lastUpdateTime < (long)player.field_6012) {
            return;
        }
        lastUpdateTime = player.field_6012;
        List<class_11200> waypoints = WaypointTracking.getWaypointsFromPlayer((class_1657)player);
        CURRENT_WAYPOINTS.clear();
        CURRENT_WAYPOINTS.addAll(waypoints);
        for (class_11200 newWaypoint : waypoints) {
            isTracked = false;
            for (class_11200 oldWaypoint : PREVIOUS_WAYPOINTS) {
                if (!newWaypoint.method_70763().equals(oldWaypoint.method_70763())) continue;
                isTracked = true;
                player.field_3944.method_70936().method_70956(newWaypoint);
            }
            if (isTracked) continue;
            player.field_3944.method_70936().method_70955(newWaypoint);
        }
        for (class_11200 oldWaypoint : PREVIOUS_WAYPOINTS) {
            isTracked = false;
            for (class_11200 newWaypoint : waypoints) {
                if (!oldWaypoint.method_70763().equals(newWaypoint.method_70763())) continue;
                isTracked = true;
            }
            if (isTracked) continue;
            player.field_3944.method_70936().method_70957(oldWaypoint);
        }
        PREVIOUS_WAYPOINTS.clear();
        PREVIOUS_WAYPOINTS.addAll(waypoints);
    }

    private static List<class_11200> getWaypointsFromPlayer(class_1657 player) {
        class_1799 offHandStack;
        WAYPOINT_NAMES.clear();
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        class_2371 mainStacks = player.method_31548().method_67533();
        if (mainStacks != null) {
            stacks.addAll((Collection<class_1799>)player.method_31548().method_67533());
        }
        if ((offHandStack = player.method_6079()) != null) {
            stacks.add(player.method_6079());
        }
        ArrayList<class_11200> waypoints = new ArrayList<class_11200>();
        for (class_1799 stack : stacks) {
            class_5321 dimension = player.method_37908().method_27983();
            waypoints.addAll(WaypointTracking.getWaypointsFromStack(player, (class_5321<class_1937>)dimension, stack));
        }
        return waypoints;
    }

    private static List<class_11200> getWaypointsFromStack(class_1657 player, class_5321<class_1937> dimension, class_1799 stack) {
        class_9276 contentsComponent;
        class_9291 trackerComponent;
        Either source;
        class_11208.class_11209 config;
        class_4208 pos;
        Optional lastDeathPos;
        ArrayList<class_11200> waypoints = new ArrayList<class_11200>();
        if (ConfigManager.shouldShowRecovery() && (lastDeathPos = player.method_43122()).isPresent() && stack.method_31574(class_1802.field_38747) && (pos = (class_4208)lastDeathPos.get()).comp_2207() == dimension && pos.comp_2208() != null) {
            config = new class_11208.class_11209();
            config.field_60166 = LocatorLodestones.DEATH_STYLE;
            config.field_59791 = Optional.ofNullable(ColorHandler.getColor(stack).orElse(ConfigManager.getRecoveryColor().getColorWithAlpha()));
            source = Either.right((Object)("death_" + String.valueOf(pos)));
            waypoints.add((class_11200)new class_11200.class_11206(source, config, WaypointTracking.bufFromPos(pos.comp_2208())));
            WAYPOINT_NAMES.put((Either<UUID, String>)source, WaypointTracking.getText(stack));
        }
        if ((trackerComponent = (class_9291)stack.method_58694(class_9334.field_49614)) != null && trackerComponent.comp_2402().isPresent() && (pos = (class_4208)trackerComponent.comp_2402().get()).comp_2207() == dimension && pos.comp_2208() != null) {
            config = new class_11208.class_11209();
            config.field_60166 = LocatorLodestones.LODESTONE_STYLE;
            config.field_59791 = Optional.ofNullable(ColorHandler.getColor(stack).orElse(ConfigManager.getLodestoneColor().getColorWithAlpha()));
            source = Either.right((Object)("lodestone_" + String.valueOf(pos)));
            waypoints.add((class_11200)new class_11200.class_11206(source, config, WaypointTracking.bufFromPos(pos.comp_2208())));
            WAYPOINT_NAMES.put((Either<UUID, String>)source, WaypointTracking.getText(stack));
        }
        if (ConfigManager.shouldShowBundled() && (contentsComponent = (class_9276)stack.method_58694(class_9334.field_49650)) != null) {
            contentsComponent.method_59707().forEach(bundledStack -> waypoints.addAll(WaypointTracking.getWaypointsFromStack(player, dimension, bundledStack)));
        }
        return waypoints;
    }

    private static class_2540 bufFromPos(class_2338 pos) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(pos.method_10263());
        buf.method_10804(pos.method_10264());
        buf.method_10804(pos.method_10260());
        return buf;
    }

    private static Optional<class_2561> getText(class_1799 stack) {
        class_2561 text = (class_2561)stack.method_58694(class_9334.field_49631);
        if (text == null) {
            text = (class_2561)stack.method_58694(class_9334.field_50239);
        }
        return ColorHandler.removeColorCode(text);
    }
}

