/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.locator_lodestones.config;

import com.mojang.serialization.Codec;
import net.minecraft.class_9848;
import net.pneumono.locator_lodestones.LocatorLodestones;
import org.jetbrains.annotations.Nullable;

public record ColorProvider(@Nullable Integer color) {
    public static final Codec<ColorProvider> CODEC = Codec.STRING.xmap(ColorProvider::validate, ColorProvider::asString);

    public static ColorProvider validate(String color) {
        try {
            return new ColorProvider(Integer.parseInt(color, 16));
        }
        catch (NumberFormatException e) {
            if (!color.equals("random")) {
                LocatorLodestones.LOGGER.error("Invalid config value '{}'", (Object)color);
            }
            return new ColorProvider(null);
        }
    }

    @Nullable
    public Integer getColorWithAlpha() {
        return this.color == null ? null : Integer.valueOf(class_9848.method_61330((int)255, (int)this.color));
    }

    public String asString() {
        if (this.color != null) {
            return Integer.toString(this.color, 16);
        }
        return "random";
    }
}

