/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.locator_lodestones.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.pneumono.locator_lodestones.LocatorLodestones;
import net.pneumono.locator_lodestones.config.ColorProvider;
import net.pneumono.locator_lodestones.config.Config;

public class ConfigManager {
    private static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("locator_lodestones.json");
    public static Config CONFIG = Config.DEFAULT;

    public static void initConfig() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)LocatorLodestones.id("reloadconfig").toString()).executes(context -> {
            ConfigManager.reloadConfig();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"locator_lodestones.reload"));
            return 1;
        })));
        ConfigManager.reloadConfig();
    }

    public static void reloadConfig() {
        CONFIG = ConfigManager.readConfigFromFile();
        ConfigManager.writeConfigToFile(CONFIG);
    }

    public static Config readConfigFromFile() {
        JsonElement element;
        DataResult result;
        if (CONFIG_FILE.toFile().exists() && (result = Config.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)(element = ConfigManager.readObjectFromFile()))).isSuccess()) {
            return (Config)((Pair)result.getOrThrow()).getFirst();
        }
        return Config.DEFAULT;
    }

    public static JsonElement readObjectFromFile() {
        JsonElement jsonElement;
        block9: {
            BufferedReader reader = Files.newBufferedReader(CONFIG_FILE);
            try {
                jsonElement = (JsonElement)new GsonBuilder().setPrettyPrinting().create().fromJson((Reader)reader, JsonElement.class);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LocatorLodestones.LOGGER.error("Could not read config file. Default values will be used instead", (Throwable)e);
                    return null;
                }
                catch (JsonSyntaxException e) {
                    LocatorLodestones.LOGGER.error("Config file did not use valid syntax. Default config values will be used instead", (Throwable)e);
                    return null;
                }
            }
            ((Reader)reader).close();
        }
        return jsonElement;
    }

    public static void writeConfigToFile(Config config) {
        DataResult result = Config.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config);
        if (result.isSuccess()) {
            ConfigManager.writeObjectToFile((JsonElement)result.getOrThrow());
        } else {
            LocatorLodestones.LOGGER.error("Could not create default config object!");
        }
    }

    public static void writeObjectToFile(JsonElement element) {
        try {
            BufferedWriter writer = Files.newBufferedWriter(CONFIG_FILE, new OpenOption[0]);
            new GsonBuilder().setPrettyPrinting().create().toJson(element, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            LocatorLodestones.LOGGER.error("Could not write configuration file.", (Throwable)e);
        }
    }

    public static boolean tabForcesLocatorBar() {
        return CONFIG.tabForcesLocatorBar();
    }

    public static boolean tabShowsNames() {
        return CONFIG.tabShowsNames();
    }

    public static boolean shouldShowRecovery() {
        return CONFIG.shouldShowRecovery();
    }

    public static boolean shouldShowBundled() {
        return CONFIG.shouldShowBundled();
    }

    public static boolean shouldShowInSpectator() {
        return CONFIG.shouldShowInSpectator();
    }

    public static boolean colorCustomization() {
        return CONFIG.colorCustomization();
    }

    public static ColorProvider getLodestoneColor() {
        return CONFIG.getLodestoneColor();
    }

    public static ColorProvider getRecoveryColor() {
        return CONFIG.getRecoveryColor();
    }
}

