package net.pneumono.locator_lodestones;

import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_9334;
import net.minecraft.class_9848;
import net.pneumono.locator_lodestones.config.ConfigManager;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ColorHandler {
    public static Optional<Integer> getColor(class_1799 stack) {
        if (!ConfigManager.colorCustomization()) return Optional.empty();

        Optional<Integer> color = getColor(stack.method_58694(class_9334.field_49631));
        if (color.isEmpty()) {
            color = getColor(stack.method_58694(class_9334.field_50239));
        }
        return color;
    }

    public static Optional<Integer> getColor(class_2561 text) {
        if (text == null) {
            return Optional.empty();
        } else {
            return getColor(text.getString());
        }
    }

    public static Optional<Integer> getColor(String text) {
        if (text == null) {
            return Optional.empty();
        }

        Matcher matcher = Pattern.compile("#[0-9a-fA-F]{6}").matcher(text);

        String string = null;
        if (matcher.find()) {
            string = matcher.group();
        }

        return parseCode(string);
    }

    public static Optional<Integer> parseCode(@Nullable String string) {
        if (string == null) return Optional.empty();

        try {
            return Optional.of(class_9848.method_61330(255, Integer.parseInt(string, 1, 7, 16)));
        } catch (NullPointerException | IndexOutOfBoundsException | NumberFormatException e) {
            LocatorLodestones.LOGGER.error("String '{}' is not a valid color code!", string, e);
            return Optional.empty();
        }
    }

    public static Optional<class_2561> removeColorCode(class_2561 text) {
        if (text == null) return Optional.empty();

        String string = text.getString().replaceAll("( ?)([({<\\[]?)(#[0-9a-fA-F]{6})([)}>\\]]?)", "");
        return string.isEmpty() ? Optional.empty() : Optional.of(class_2561.method_43470(string));
    }
}
