/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.locator_lodestones;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_9334;
import net.minecraft.class_9848;
import net.pneumono.locator_lodestones.LocatorLodestones;
import net.pneumono.locator_lodestones.config.ConfigManager;
import org.jetbrains.annotations.Nullable;

public class ColorHandler {
    public static Optional<Integer> getColor(class_1799 stack) {
        if (!ConfigManager.colorCustomization()) {
            return Optional.empty();
        }
        Optional<Integer> color = ColorHandler.getColor((class_2561)stack.method_58694(class_9334.field_49631));
        if (color.isEmpty()) {
            color = ColorHandler.getColor((class_2561)stack.method_58694(class_9334.field_50239));
        }
        return color;
    }

    public static Optional<Integer> getColor(class_2561 text) {
        if (text == null) {
            return Optional.empty();
        }
        return ColorHandler.getColor(text.getString());
    }

    public static Optional<Integer> getColor(String text) {
        if (text == null) {
            return Optional.empty();
        }
        Matcher hexMatcher = Pattern.compile("#[0-9a-fA-F]{6}").matcher(text);
        Matcher codeMatcher = Pattern.compile("[\u00a7&][0-9a-f]").matcher(text);
        if (hexMatcher.find()) {
            return ColorHandler.parseHexCode(hexMatcher.group());
        }
        if (codeMatcher.find()) {
            return ColorHandler.parseFormattingCode(codeMatcher.group());
        }
        return Optional.empty();
    }

    public static Optional<Integer> parseFormattingCode(@Nullable String string) {
        class_124 formatting;
        if (string == null) {
            return Optional.empty();
        }
        if (string.length() < 2) {
            LocatorLodestones.LOGGER.error("String '{}' is not a valid formatting code!", (Object)string);
        }
        if ((formatting = class_124.method_544((char)string.charAt(1))) == null) {
            return Optional.empty();
        }
        Integer integer = formatting.method_532();
        return integer == null ? Optional.empty() : Optional.of(class_9848.method_61330((int)255, (int)integer));
    }

    public static Optional<Integer> parseHexCode(@Nullable String string) {
        if (string == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(class_9848.method_61330((int)255, (int)Integer.parseInt(string, 1, 7, 16)));
        }
        catch (IndexOutOfBoundsException | NullPointerException | NumberFormatException e) {
            LocatorLodestones.LOGGER.error("String '{}' is not a valid hex code!", (Object)string, (Object)e);
            return Optional.empty();
        }
    }

    public static Optional<class_2561> removeColorCode(class_2561 text) {
        if (text == null) {
            return Optional.empty();
        }
        String string = text.getString().replaceAll("( ?)([({<\\[]?)(#[0-9a-fA-F]{6})([)}>\\]]?)", "").replaceAll("( ?)([({<\\[]?)([\u00a7&][0-9a-f])([)}>\\]]?)", "");
        return string.isEmpty() ? Optional.empty() : Optional.of(class_2561.method_43470((String)string));
    }
}

