package net.pneumono.locator_lodestones;

import com.mojang.datafixers.util.Either;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_11200;
import net.minecraft.class_11208;
import net.minecraft.class_11264;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import net.minecraft.class_9276;
import net.minecraft.class_9291;
import net.minecraft.class_9334;
import net.pneumono.locator_lodestones.config.ConfigManager;

import java.util.*;

public class WaypointTracking {
    private static final Map<Either<UUID, String>, class_11200> WAYPOINTS = new HashMap<>();
    private static final Map<Either<UUID, String>, Optional<class_2561>> WAYPOINT_NAMES = new HashMap<>();
    private static boolean dirty = false;
    private static long lastUpdateTime = 0;

    public static Collection<class_11200> getWaypoints() {
        return WAYPOINTS.values();
    }

    public static Optional<class_2561> getWaypointName(Either<UUID, String> source) {
        return WAYPOINT_NAMES.get(source);
    }

    public static void markWaypointsDirty() {
        dirty = true;
    }

    public static void resetWaypoints() {
        WAYPOINTS.clear();
        WAYPOINT_NAMES.clear();
        lastUpdateTime = 0;
        markWaypointsDirty();
    }

    public static void updateWaypoints(class_746 player) {
        if (!dirty || player == null || (lastUpdateTime + 20 > player.field_6012 && lastUpdateTime < player.field_6012)) return;
        lastUpdateTime = player.field_6012;
        dirty = false;

        Map<Either<UUID, String>, class_11200> oldWaypoints = new HashMap<>(WAYPOINTS);
        WAYPOINTS.clear();
        getWaypointsFromPlayer(player).forEach(waypoint -> WAYPOINTS.put(waypoint.method_70763(), waypoint));

        class_11264 waypointHandler = player.field_3944.method_70936();

        for (class_11200 newWaypoint : WAYPOINTS.values()) {
            if (oldWaypoints.containsKey(newWaypoint.method_70763())) {
                waypointHandler.method_70956(newWaypoint);
            } else {
                waypointHandler.method_70955(newWaypoint);
            }
        }

        for (class_11200 oldWaypoint : oldWaypoints.values()) {
            if (!WAYPOINTS.containsKey(oldWaypoint.method_70763())) {
                waypointHandler.method_70957(oldWaypoint);
            }
        }
    }

    private static List<class_11200> getWaypointsFromPlayer(class_1657 player) {
        WAYPOINT_NAMES.clear();

        List<class_1799> stacks = new ArrayList<>();
        class_2371<class_1799> mainStacks = player.method_31548().method_67533();
        if (mainStacks != null) {
            stacks.addAll(player.method_31548().method_67533());
        }
        class_1799 offHandStack = player.method_6079();
        if (offHandStack != null) {
            stacks.add(player.method_6079());
        }

        List<class_11200> waypoints = new ArrayList<>();
        for (class_1799 stack : stacks) {
            //? if >=1.21.9 {
            class_5321<class_1937> dimension = player.method_73183().method_27983();
            //?} else {
            /*RegistryKey<World> dimension = player.getWorld().getRegistryKey();
            *///?}
            waypoints.addAll(getWaypointsFromStack(player, dimension, stack));
        }
        return waypoints;
    }

    private static List<class_11200> getWaypointsFromStack(class_1657 player, class_5321<class_1937> dimension, class_1799 stack) {
        List<class_11200> waypoints = new ArrayList<>();

        if (ConfigManager.shouldShowRecovery()) {
            Optional<class_4208> lastDeathPos = player.method_43122();
            if (lastDeathPos.isPresent() && stack.method_31574(class_1802.field_38747)) {
                class_4208 pos = lastDeathPos.get();
                if (pos.comp_2207() == dimension && pos.comp_2208() != null) {
                    class_11208.class_11209 config = new class_11208.class_11209();
                    config.field_60166 = LocatorLodestones.DEATH_STYLE;
                    config.field_59791 = Optional.ofNullable(
                            ColorHandler.getColor(stack).orElse(ConfigManager.getRecoveryColor().getColorWithAlpha())
                    );
                    Either<UUID, String> source = Either.right("death_" + pos);
                    waypoints.add(new class_11200.class_11206(
                            source,
                            config,
                            bufFromPos(pos.comp_2208())
                    ));
                    WAYPOINT_NAMES.put(source, getText(stack));
                }
            }
        }

        class_9291 trackerComponent = stack.method_58694(class_9334.field_49614);
        if (trackerComponent != null && trackerComponent.comp_2402().isPresent()) {

            class_4208 pos = trackerComponent.comp_2402().get();
            if (pos.comp_2207() == dimension && pos.comp_2208() != null) {
                class_11208.class_11209 config = new class_11208.class_11209();
                config.field_60166 = LocatorLodestones.LODESTONE_STYLE;
                config.field_59791 = Optional.ofNullable(
                        ColorHandler.getColor(stack).orElse(ConfigManager.getLodestoneColor().getColorWithAlpha())
                );
                Either<UUID, String> source = Either.right("lodestone_" + pos);
                waypoints.add(new class_11200.class_11206(
                        source,
                        config,
                        bufFromPos(pos.comp_2208())
                ));
                WAYPOINT_NAMES.put(source, getText(stack));
            }
        }

        if (ConfigManager.shouldShowBundled()) {
            class_9276 contentsComponent = stack.method_58694(class_9334.field_49650);
            if (contentsComponent != null) {
                contentsComponent.method_59707().forEach(
                        bundledStack -> waypoints.addAll(getWaypointsFromStack(player, dimension, bundledStack))
                );
            }
        }

        return waypoints;
    }

    private static class_2540 bufFromPos(class_2338 pos) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(pos.method_10263());
        buf.method_10804(pos.method_10264());
        buf.method_10804(pos.method_10260());
        return buf;
    }

    private static Optional<class_2561> getText(class_1799 stack) {
        class_2561 text = stack.method_58694(class_9334.field_49631);
        if (text == null) {
            text = stack.method_58694(class_9334.field_50239);
        }
        return ColorHandler.removeColorCode(text);
    }
}
