/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative;

import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.world.phys.data.PhysService;
import ua.mcchickenstudio.opencreative.coding.blocks.events.WorldListener;
import ua.mcchickenstudio.opencreative.commands.ChatCommand;
import ua.mcchickenstudio.opencreative.commands.CreativeCommand;
import ua.mcchickenstudio.opencreative.commands.EditCommand;
import ua.mcchickenstudio.opencreative.commands.LocateCommand;
import ua.mcchickenstudio.opencreative.commands.MenuCommand;
import ua.mcchickenstudio.opencreative.commands.ModuleCommand;
import ua.mcchickenstudio.opencreative.commands.SpawnCommand;
import ua.mcchickenstudio.opencreative.commands.ValueCommand;
import ua.mcchickenstudio.opencreative.commands.minecraft.GamemodeCommand;
import ua.mcchickenstudio.opencreative.commands.minecraft.GiveCommand;
import ua.mcchickenstudio.opencreative.commands.minecraft.PlaySoundCommand;
import ua.mcchickenstudio.opencreative.commands.minecraft.StopSoundCommand;
import ua.mcchickenstudio.opencreative.commands.minecraft.TeleportCommand;
import ua.mcchickenstudio.opencreative.commands.minecraft.TimeCommand;
import ua.mcchickenstudio.opencreative.commands.minecraft.WeatherCommand;
import ua.mcchickenstudio.opencreative.commands.world.AdvertisementCommand;
import ua.mcchickenstudio.opencreative.commands.world.EnvironmentCommand;
import ua.mcchickenstudio.opencreative.commands.world.JoinCommand;
import ua.mcchickenstudio.opencreative.commands.world.WorldCommand;
import ua.mcchickenstudio.opencreative.commands.world.modes.BuildCommand;
import ua.mcchickenstudio.opencreative.commands.world.modes.DevCommand;
import ua.mcchickenstudio.opencreative.commands.world.modes.PlayCommand;
import ua.mcchickenstudio.opencreative.commands.world.reputation.DislikeCommand;
import ua.mcchickenstudio.opencreative.commands.world.reputation.LikeCommand;
import ua.mcchickenstudio.opencreative.indev.OfflineWander;
import ua.mcchickenstudio.opencreative.indev.Wander;
import ua.mcchickenstudio.opencreative.listeners.CreativeListener;
import ua.mcchickenstudio.opencreative.listeners.creative.PlanetListener;
import ua.mcchickenstudio.opencreative.listeners.entity.EntityDamageListener;
import ua.mcchickenstudio.opencreative.listeners.entity.EntitySpawnListener;
import ua.mcchickenstudio.opencreative.listeners.entity.EntityStateListener;
import ua.mcchickenstudio.opencreative.listeners.player.BucketListener;
import ua.mcchickenstudio.opencreative.listeners.player.ChangedWorld;
import ua.mcchickenstudio.opencreative.listeners.player.ChatListener;
import ua.mcchickenstudio.opencreative.listeners.player.ClickListener;
import ua.mcchickenstudio.opencreative.listeners.player.DeathListener;
import ua.mcchickenstudio.opencreative.listeners.player.DestroyBlockListener;
import ua.mcchickenstudio.opencreative.listeners.player.DropItemListener;
import ua.mcchickenstudio.opencreative.listeners.player.GameModeListener;
import ua.mcchickenstudio.opencreative.listeners.player.InteractListener;
import ua.mcchickenstudio.opencreative.listeners.player.JoinListener;
import ua.mcchickenstudio.opencreative.listeners.player.MoveListener;
import ua.mcchickenstudio.opencreative.listeners.player.PlaceBlockListener;
import ua.mcchickenstudio.opencreative.listeners.player.PotionListener;
import ua.mcchickenstudio.opencreative.listeners.player.QuitListener;
import ua.mcchickenstudio.opencreative.listeners.player.RespawnListener;
import ua.mcchickenstudio.opencreative.listeners.player.TeleportListener;
import ua.mcchickenstudio.opencreative.listeners.world.BlockChangeListener;
import ua.mcchickenstudio.opencreative.listeners.world.RedstoneListener;
import ua.mcchickenstudio.opencreative.managers.blocks.BlocksManager;
import ua.mcchickenstudio.opencreative.managers.economy.Economy;
import ua.mcchickenstudio.opencreative.managers.modules.ModuleManager;
import ua.mcchickenstudio.opencreative.managers.modules.Moduler;
import ua.mcchickenstudio.opencreative.managers.packets.PacketManager;
import ua.mcchickenstudio.opencreative.managers.space.PlanetsManager;
import ua.mcchickenstudio.opencreative.managers.space.Space;
import ua.mcchickenstudio.opencreative.managers.stability.DisabledWatchdog;
import ua.mcchickenstudio.opencreative.managers.stability.StabilityManager;
import ua.mcchickenstudio.opencreative.managers.updater.HangarUpdater;
import ua.mcchickenstudio.opencreative.managers.updater.Updater;
import ua.mcchickenstudio.opencreative.menus.Menus;
import ua.mcchickenstudio.opencreative.settings.Settings;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.FileUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;
import ua.mcchickenstudio.opencreative.utils.hooks.HookUtils;
import ua.mcchickenstudio.opencreative.utils.hooks.Metrics;
import ua.mcchickenstudio.opencreative.utils.world.platforms.DevPlatformer;
import ua.mcchickenstudio.opencreative.utils.world.platforms.HorizontalPlatformer;
import ua.mcchickenstudio.opencreative.utils.world.platforms.VerticalPlatformer;

public final class OpenCreative
extends JavaPlugin {
    private static OpenCreative plugin;
    private final Set<Wander> wanders = new HashSet<Wander>();
    private Settings settings;
    private Economy economy;
    private Updater updater;
    private PacketManager packet;
    private PlanetsManager space;
    private ModuleManager moduler;
    private StabilityManager watchdog;
    private BlocksManager blocks;
    private DevPlatformer devPlatformer;
    private static final String version = "5.7.0";
    private static final String codename = "Well, it's possible";

    public void onLoad() {
        this.getLogger().info(String.join((CharSequence)"\n", "", "", "This software was made by Ukrainians, suffering from never-ending air alerts, explosions, and deaths.", "We're AGAINST THE WAR. This software IS NOT DESIGNED for those who support killing and robbing another country.", "", "Let us have fun, like players who create their worlds...", "McChicken Studio 2017\u20132025", ""));
    }

    public void onEnable() {
        plugin = this;
        long startTime = System.currentTimeMillis();
        this.getLogger().info("Starting OpenCreative+ 5.7.0: Well, it's possible, please wait...");
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 100, 1));
            player.showTitle(Title.title((Component)MiniMessage.miniMessage().deserialize((Object)"<white>Open<gradient:#dbdbdb:#ffd4c2>Creative</gradient><green>+ <gray>5.7.0"), (Component)Component.text((String)"\u00a7fWell, it's possible..."), (Title.Times)Title.Times.times((Duration)Duration.ofSeconds(0L), (Duration)Duration.ofSeconds(5L), (Duration)Duration.ofSeconds(0L))));
        }
        this.saveDefaultConfig();
        this.settings = new Settings();
        this.settings.load(this.getConfig());
        this.registerCommands();
        this.registerEvents();
        FileUtils.loadLocales();
        this.space = new Space();
        this.space.init();
        this.moduler = new Moduler();
        this.moduler.init();
        if (this.devPlatformer == null) {
            this.devPlatformer = new HorizontalPlatformer();
        }
        PlayerUtils.loadPermissions();
        HookUtils.loadHooks();
        FileUtils.loadPlanets();
        PhysService.run();
        FileUtils.loadModules();
        this.economy = HookUtils.getEconomy();
        this.economy.init();
        this.updater = new HangarUpdater();
        this.updater.init();
        this.packet = HookUtils.getPacketManager();
        this.packet.init();
        this.watchdog = new DisabledWatchdog();
        this.watchdog.init();
        this.blocks = HookUtils.getBlocks();
        this.blocks.init();
        long loadedTime = System.currentTimeMillis() - startTime;
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlayerUtils.teleportToLobby(player);
            this.getServer().sendActionBar(MiniMessage.miniMessage().deserialize((Object)("<white>Open<gradient:#dbdbdb:#ffd4c2>Creative</gradient><green>+ <gray>5.7.0<white> is loaded for " + loadedTime + " ms.")));
        }
        this.getLogger().info(String.join((CharSequence)"\n", "OpenCreative+ 5.7.0: Well, it's possible is loaded for " + loadedTime + " ms.", "", " Welcome to OpenCreative+ 5.7.0!", "", "  Running on " + Bukkit.getMinecraftVersion() + " server", "  Current time " + new SimpleDateFormat("dd/MM/yyyy HH:mm").format(new Date()), OpenCreative.isChristmas() ? "  Ho-ho-ho! Merry Christmas, server owners! :-) \u2746" : (OpenCreative.isHalloween() ? "  Spo-o-o-oky Halloween, server owners! O_o \ud83c\udf83" : ""), "  Well, it's possible", "  Made by McChicken Studio 2017\u20132025", ""));
        new Metrics((Plugin)this, 22001);
    }

    public void onDisable() {
        this.getLogger().info("Shutting down OpenCreative+, please wait...");
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendMessage(MiniMessage.miniMessage().deserialize((Object)" \n<white> Shutting down Open<gradient:#dbdbdb:#ffd4c2>Creative</gradient><green>+ <gray>5.7.0<white>, please wait...\n "));
            PlayerUtils.teleportToLobby(player);
        }
        FileUtils.unloadPlanets();
        this.getLogger().info(String.join((CharSequence)"\n", "", "Goodbye from OpenCreative+", "", " Well, it's possible", "  Made by McChicken Studio 2017\u20132025", ""));
    }

    public static OpenCreative getPlugin() {
        return plugin;
    }

    private void registerCommands() {
        this.getLogger().info("Registering OpenCreative+ commands...");
        int registeredCommands = 0;
        HashMap<String, Class> commands = new HashMap<String, Class>();
        commands.put("creative", CreativeCommand.class);
        commands.put("spawn", SpawnCommand.class);
        commands.put("menu", MenuCommand.class);
        commands.put("world", WorldCommand.class);
        commands.put("chat", ChatCommand.class);
        commands.put("join", JoinCommand.class);
        commands.put("ad", AdvertisementCommand.class);
        commands.put("play", PlayCommand.class);
        commands.put("build", BuildCommand.class);
        commands.put("dev", DevCommand.class);
        commands.put("environment", EnvironmentCommand.class);
        commands.put("like", LikeCommand.class);
        commands.put("dislike", DislikeCommand.class);
        commands.put("locate", LocateCommand.class);
        commands.put("gamemode", GamemodeCommand.class);
        commands.put("give", GiveCommand.class);
        commands.put("teleport", TeleportCommand.class);
        commands.put("edit", EditCommand.class);
        commands.put("playsound", PlaySoundCommand.class);
        commands.put("stopsound", StopSoundCommand.class);
        commands.put("time", TimeCommand.class);
        commands.put("weather", WeatherCommand.class);
        commands.put("value", ValueCommand.class);
        commands.put("module", ModuleCommand.class);
        for (String commandName : commands.keySet()) {
            PluginCommand command = this.getCommand(commandName);
            if (command != null) {
                try {
                    command.setExecutor((CommandExecutor)((Class)commands.get(commandName)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    ++registeredCommands;
                }
                catch (Exception error) {
                    ErrorUtils.sendCriticalErrorMessage("Couldn't register command " + commandName, error);
                }
                continue;
            }
            ErrorUtils.sendCriticalErrorMessage("Couldn't get command with name " + commandName + ", it is null. Maybe it doesn't exist in plugins.yml?");
        }
        this.getLogger().info("OpenCreative+ registered " + (String)(registeredCommands == commands.size() ? "all" : registeredCommands + "/" + commands.size()) + " commands.");
    }

    private void registerEvents() {
        Class[] listeners;
        this.getLogger().info("Registering OpenCreative+ event listeners...");
        int registeredListeners = 0;
        for (Class listenerClass : listeners = new Class[]{ChangedWorld.class, EntitySpawnListener.class, EntityDamageListener.class, JoinListener.class, QuitListener.class, RespawnListener.class, DeathListener.class, TeleportListener.class, MoveListener.class, ChatListener.class, InteractListener.class, DropItemListener.class, PlaceBlockListener.class, DestroyBlockListener.class, BucketListener.class, ClickListener.class, RedstoneListener.class, BlockChangeListener.class, Menus.class, GameModeListener.class, EntityStateListener.class, CreativeListener.class, PotionListener.class, PlanetListener.class}) {
            try {
                this.getServer().getPluginManager().registerEvents((Listener)listenerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), (Plugin)this);
                ++registeredListeners;
            }
            catch (Exception exception) {
                ErrorUtils.sendCriticalErrorMessage("Couldn't register event listener: " + listenerClass.getSimpleName(), exception);
            }
        }
        try {
            new WorldListener().registerExecutors();
        }
        catch (Exception exception) {
            ErrorUtils.sendCriticalErrorMessage("Couldn't register executors", exception);
        }
        this.getLogger().info("OpenCreative+ registered " + (String)(registeredListeners == listeners.length ? "all" : registeredListeners + "/" + listeners.length) + " event listeners.");
    }

    public static Settings getSettings() {
        return OpenCreative.getPlugin().settings;
    }

    public static void setEconomy(@NotNull Economy economy) {
        if (economy == null) {
            OpenCreative.$$$reportNull$$$0(0);
        }
        OpenCreative.getPlugin().getLogger().info("Now using economy manager: " + economy.getName());
        OpenCreative.getPlugin().economy = economy;
    }

    public static Economy getEconomy() {
        return OpenCreative.getPlugin().economy;
    }

    public static void setPacketManager(@NotNull PacketManager packetManager) {
        if (packetManager == null) {
            OpenCreative.$$$reportNull$$$0(1);
        }
        OpenCreative.getPlugin().getLogger().info("Now using packet manager: " + packetManager.getName());
        OpenCreative.getPlugin().packet = packetManager;
    }

    public static PacketManager getPacketManager() {
        return OpenCreative.getPlugin().packet;
    }

    public static void setBlocksManager(@NotNull BlocksManager blocksManager) {
        if (blocksManager == null) {
            OpenCreative.$$$reportNull$$$0(2);
        }
        OpenCreative.getPlugin().getLogger().info("Now using blocks manager: " + blocksManager.getName());
        OpenCreative.getPlugin().blocks = blocksManager;
    }

    public static BlocksManager getBlocksManager() {
        return OpenCreative.getPlugin().blocks;
    }

    public static void setBlocksManager(@NotNull ModuleManager moduleManager) {
        if (moduleManager == null) {
            OpenCreative.$$$reportNull$$$0(3);
        }
        OpenCreative.getPlugin().getLogger().info("Now using module manager: " + moduleManager.getName());
        OpenCreative.getPlugin().moduler = moduleManager;
    }

    public static ModuleManager getModuleManager() {
        return OpenCreative.getPlugin().moduler;
    }

    public static void setDevPlatformer(@NotNull DevPlatformer platformsManager) {
        if (platformsManager == null) {
            OpenCreative.$$$reportNull$$$0(4);
        }
        if (!(platformsManager instanceof VerticalPlatformer) && !(platformsManager instanceof HorizontalPlatformer)) {
            OpenCreative.getPlugin().getLogger().info("Now using dev platforms manager: " + platformsManager.getName());
        }
        OpenCreative.getPlugin().devPlatformer = platformsManager;
    }

    public static DevPlatformer getDevPlatformer() {
        return OpenCreative.getPlugin().devPlatformer;
    }

    public static void setPlanetsManager(@NotNull PlanetsManager planetsManager) {
        if (planetsManager == null) {
            OpenCreative.$$$reportNull$$$0(5);
        }
        OpenCreative.getPlugin().getLogger().info("Now using planets manager: " + planetsManager.getName());
        OpenCreative.getPlugin().space = planetsManager;
    }

    public static PlanetsManager getPlanetsManager() {
        return OpenCreative.getPlugin().space;
    }

    public static void setStability(@NotNull StabilityManager stabilityManager) {
        if (stabilityManager == null) {
            OpenCreative.$$$reportNull$$$0(6);
        }
        OpenCreative.getPlugin().getLogger().info("Now using stability manager: " + stabilityManager.getName());
        OpenCreative.getPlugin().watchdog = stabilityManager;
    }

    public static StabilityManager getStability() {
        return OpenCreative.getPlugin().watchdog;
    }

    public static String getVersion() {
        return version;
    }

    public static Updater getUpdater() {
        return OpenCreative.getPlugin().updater;
    }

    public static String getCodename() {
        return codename;
    }

    private static boolean isChristmas() {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            return calendar.get(2) == 11 && calendar.get(5) == 25;
        }
        catch (Exception error) {
            return false;
        }
    }

    private static boolean isHalloween() {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            return calendar.get(2) == 9 && calendar.get(5) == 31;
        }
        catch (Exception error) {
            return false;
        }
    }

    public Wander registerWander(@NotNull Player player) {
        if (player == null) {
            OpenCreative.$$$reportNull$$$0(7);
        }
        Wander wander = new Wander((OfflinePlayer)player);
        this.wanders.add(wander);
        return wander;
    }

    public void unregisterWander(@NotNull Player player) {
        if (player == null) {
            OpenCreative.$$$reportNull$$$0(8);
        }
        this.wanders.removeIf(wander -> player.getUniqueId().equals(wander.getUniqueId()));
    }

    @Nullable
    public static Wander getWander(@NotNull UUID uuid) {
        if (uuid == null) {
            OpenCreative.$$$reportNull$$$0(9);
        }
        for (Wander wander : new ArrayList<Wander>(OpenCreative.getPlugin().wanders)) {
            if (!wander.getUniqueId().equals(uuid)) continue;
            return wander;
        }
        return null;
    }

    @NotNull
    public static Wander getWander(@NotNull Player player) {
        if (player == null) {
            OpenCreative.$$$reportNull$$$0(10);
        }
        for (Wander wander : new ArrayList<Wander>(OpenCreative.getPlugin().wanders)) {
            if (!wander.getUniqueId().equals(player.getUniqueId())) continue;
            Wander wander2 = wander;
            if (wander2 == null) {
                OpenCreative.$$$reportNull$$$0(11);
            }
            return wander2;
        }
        Wander wander = OpenCreative.getPlugin().registerWander(player);
        if (wander == null) {
            OpenCreative.$$$reportNull$$$0(12);
        }
        return wander;
    }

    @NotNull
    public static OfflineWander getOfflineWander(@NotNull UUID uuid) {
        if (uuid == null) {
            OpenCreative.$$$reportNull$$$0(13);
        }
        return new OfflineWander(uuid);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "economy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packetManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blocksManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platformsManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "planetsManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stabilityManager";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uuid";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/OpenCreative";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/OpenCreative";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getWander";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setEconomy";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setPacketManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setBlocksManager";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDevPlatformer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setPlanetsManager";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setStability";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerWander";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unregisterWander";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getWander";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getOfflineWander";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12 -> new IllegalStateException(string);
        };
    }
}

