/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.scheduler.BukkitRunnable;
import ua.mcchickenstudio.opencreative.coding.CodeConfiguration;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executors;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class CodeScript {
    private final Planet planet;
    private final Executors executors;
    private CodeConfiguration scriptConfig;

    public CodeScript(Planet planet) {
        this.planet = planet;
        this.executors = new Executors(planet);
        this.scriptConfig = new CodeConfiguration();
    }

    public void loadCode() {
        ErrorUtils.sendCodingDebugLog(this.planet, "Starting code, please wait...");
        File scriptFile = ua.mcchickenstudio.opencreative.utils.FileUtils.getPlanetScriptFile(this.planet);
        long totalSize = ua.mcchickenstudio.opencreative.utils.FileUtils.getFileSize(scriptFile);
        long limit = (long)this.planet.getGroup().getScriptSizeLimit() * 1024L * 1024L;
        if (totalSize > limit) {
            ErrorUtils.sendPlanetErrorMessage(this.planet, MessageUtils.getLocaleMessage("world.script-size-limit").replace("%amount%", FileUtils.byteCountToDisplaySize(totalSize)).replace("%limit%", String.valueOf(this.planet.getGroup().getScriptSizeLimit())));
            ErrorUtils.sendCodingDebugLog(this.planet, "Script File is too large to load :(");
            return;
        }
        this.scriptConfig = CodeConfiguration.loadConfiguration(scriptFile);
        new BukkitRunnable(){

            public void run() {
                CodeScript.this.executors.load(ua.mcchickenstudio.opencreative.utils.FileUtils.getPlanetScriptFile(CodeScript.this.planet));
            }
        }.run();
    }

    public boolean saveCode() {
        long time = System.currentTimeMillis();
        ErrorUtils.sendCodingDebugLog(this.planet, "Saving code...");
        try {
            this.scriptConfig.save(ua.mcchickenstudio.opencreative.utils.FileUtils.getPlanetScriptFile(this.planet));
            ErrorUtils.sendCodingDebugLog(this.planet, "Saved code in " + (System.currentTimeMillis() - time) + " ms.");
            return true;
        }
        catch (IOException error) {
            ErrorUtils.sendCriticalErrorMessage("An IO Exception has occurred while saving code.", error);
            return false;
        }
    }

    public void clear() {
        this.executors.clear();
        ConfigurationSection section = this.scriptConfig.getConfigurationSection("code.blocks");
        if (section == null) {
            return;
        }
        this.scriptConfig.set("old-code.blocks", null);
        Map newCode = section.getValues(false);
        this.scriptConfig.set("old-code.blocks", newCode);
        this.scriptConfig.set("code.blocks", null);
        try {
            this.scriptConfig.save(ua.mcchickenstudio.opencreative.utils.FileUtils.getPlanetScriptFile(this.planet));
        }
        catch (IOException exception) {
            ErrorUtils.sendCriticalErrorMessage("An error has occurred while clearing and saving code script " + this.getPlanet().getWorldName(), exception);
        }
    }

    public CodeConfiguration getConfig() {
        return this.scriptConfig;
    }

    public void unload() {
        this.scriptConfig = new CodeConfiguration();
        this.executors.clear();
    }

    public Executors getExecutors() {
        return this.executors;
    }

    public Planet getPlanet() {
        return this.planet;
    }
}

