/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.apache.commons.io.FileUtils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.coding.CodeConfiguration;
import ua.mcchickenstudio.opencreative.coding.CodeScript;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorType;
import ua.mcchickenstudio.opencreative.coding.menus.layouts.ArgumentSlot;
import ua.mcchickenstudio.opencreative.coding.values.EventValues;
import ua.mcchickenstudio.opencreative.coding.variables.ValueType;
import ua.mcchickenstudio.opencreative.coding.variables.VariableLink;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.planets.DevPlatform;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class CodingBlockParser {
    private final long maxScriptSize;

    public CodingBlockParser(@NotNull DevPlanet devPlanet) {
        if (devPlanet == null) {
            CodingBlockParser.$$$reportNull$$$0(0);
        }
        this(devPlanet.getPlanet().getGroup().getScriptSizeLimit());
    }

    public CodingBlockParser(int scriptSizeLimit) {
        this.maxScriptSize = (long)scriptSizeLimit * 1024L * 1024L;
    }

    public void parseCode(DevPlanet devPlanet) {
        if (!devPlanet.isCodeChanged()) {
            ErrorUtils.sendCodingDebugLog(devPlanet.getPlanet(), "Not parsing code, nothing was changed.");
            return;
        }
        long time = System.currentTimeMillis();
        ErrorUtils.sendCodingDebugLog(devPlanet.getPlanet(), "Shutting down executors and clearing...");
        devPlanet.getPlanet().getTerritory().stopBukkitRunnables();
        CodeScript script = devPlanet.getPlanet().getTerritory().getScript();
        script.clear();
        ErrorUtils.sendCodingDebugLog(devPlanet.getPlanet(), "Parsing every block, please wait...");
        this.parseAllExecutors(devPlanet, script.getConfig());
        ErrorUtils.sendCodingDebugLog(devPlanet.getPlanet(), "Parsed code in " + (System.currentTimeMillis() - time) + " ms.");
        if (script.saveCode()) {
            devPlanet.getPlanet().getTerritory().getScript().loadCode();
        }
    }

    public void parseAllExecutors(DevPlanet devPlanet, CodeConfiguration config) {
        ArrayList<Location> locations = new ArrayList<Location>();
        List<DevPlatform> platforms = devPlanet.getPlatforms();
        for (DevPlatform platform : platforms) {
            Location begin = devPlanet.getDevPlatformer().getPlatformBeginLocation(platform);
            int y = begin.getBlockY() + 1;
            int x = begin.getBlockX() + 4;
            for (int z = begin.getBlockZ() + 4; z <= platform.getEndCoordinate() - 4; z += 4) {
                Block executorBlock = devPlanet.getWorld().getBlockAt(x, y, z);
                locations.add(executorBlock.getLocation());
            }
        }
        this.parseExecutors(devPlanet, config, locations);
    }

    public boolean parseExecutors(DevPlanet devPlanet, CodeConfiguration config, List<Location> executorsLocations) {
        boolean isCodeFine = true;
        World world = devPlanet.getWorld();
        ArrayList<Block> unknownBlocks = new ArrayList<Block>();
        List<DevPlatform> platforms = devPlanet.getPlatforms();
        Collections.reverse(platforms);
        boolean notDependsOnHeight = devPlanet.getDevPlatformer().notDependsOnHeight();
        long argumentsSize = 0L;
        for (Location executorLocation : executorsLocations) {
            int executorX = executorLocation.getBlockX();
            int y = executorLocation.getBlockY();
            int z = executorLocation.getBlockZ();
            Block executorBlock = world.getBlockAt(executorX, y, z);
            ExecutorCategory executorCategory = ExecutorCategory.getByMaterial(executorBlock.getType());
            ExecutorType executorType = ExecutorType.getType(executorBlock);
            if (executorCategory == null || executorType == null) {
                if ((executorCategory != null || !this.isSignEmpty(executorBlock, (byte)2)) && (executorType != null || !this.isSignEmpty(executorBlock, (byte)3))) continue;
                unknownBlocks.add(executorBlock);
                continue;
            }
            config.saveExecutorBlock(executorBlock, notDependsOnHeight, executorCategory, executorType);
            ArrayList<String> multiActions = new ArrayList<String>();
            for (int x = executorX + 2; x <= executorX + 92; x += 2) {
                Block actionBlock = world.getBlockAt(x, y, z);
                ActionCategory actionCategory = ActionCategory.getByMaterial(actionBlock.getType());
                ActionType actionType = ActionType.getType(actionBlock);
                Target actionTarget = Target.getBySign(actionBlock.getLocation());
                Block containerBlock = actionBlock.getRelative(BlockFace.UP);
                if (actionCategory != null && actionCategory != ActionCategory.ELSE_CONDITION && actionCategory.isMultiAction()) {
                    multiActions.add((actionCategory.isCondition() ? "condition_block_" : "multi_action_") + config.getBlockNumber(actionBlock));
                    if (actionType == null) continue;
                }
                if (actionCategory == null || actionType == null) {
                    if (actionBlock.getType() != Material.END_STONE && (actionCategory == null && this.isSignEmpty(actionBlock, (byte)2) || actionType == null && this.isSignEmpty(actionBlock, (byte)3))) {
                        unknownBlocks.add(actionBlock);
                    }
                    if (world.getBlockAt(x + 1, y, z).getType() != Material.PISTON) continue;
                    if (!multiActions.isEmpty()) {
                        String last = (String)multiActions.getLast();
                        multiActions.remove(last);
                        if (world.getBlockAt(x + 2, y, z).getType() != Material.END_STONE) continue;
                        multiActions.add(last + ".else");
                        x += 2;
                        continue;
                    }
                    ErrorUtils.sendPlanetCompileErrorMessage(devPlanet.getPlanet(), world.getBlockAt(x + 1, y, z), MessageUtils.getLocaleMessage("coding-error.bad-piston"));
                    isCodeFine = false;
                    continue;
                }
                config.saveActionBlock(executorBlock, notDependsOnHeight, multiActions, actionBlock, actionCategory, actionType, actionTarget);
                BlockState blockState = containerBlock.getState();
                if (!(blockState instanceof InventoryHolder)) continue;
                InventoryHolder container = (InventoryHolder)blockState;
                int slot = 0;
                ItemStack[] content = container.getInventory().getContents();
                if (actionType.getCategory() == ActionCategory.SELECTION_ACTION && (actionType = ActionType.getTypeFromSelectionAction(actionBlock)) == null) continue;
                for (ArgumentSlot argSlot : actionType.getArgumentsSlots()) {
                    ItemStack item = content[slot];
                    if (argSlot.isList()) {
                        config.saveArguments(executorBlock, notDependsOnHeight, multiActions, actionBlock, argSlot.getPath(), null, ValueType.LIST);
                        for (byte i = 1; i < argSlot.getListSize() + 1; i = (byte)((byte)(i + 1))) {
                            if (slot < content.length) {
                                item = content[slot];
                                if (item == null) {
                                    if (argSlot.acceptEmptyItems()) {
                                        item = new ItemStack(Material.AIR);
                                        value = CodingBlockParser.parseItemValue(item);
                                        if ((argumentsSize += (long)value.toString().getBytes(StandardCharsets.UTF_8).length) > this.maxScriptSize) {
                                            this.onArgumentsTooBig(devPlanet, actionBlock, argumentsSize);
                                            return false;
                                        }
                                        config.saveArguments(executorBlock, notDependsOnHeight, multiActions, actionBlock, argSlot.getPath() + ".value." + i, value, CodingBlockParser.parseItemType(item));
                                    }
                                } else {
                                    value = CodingBlockParser.parseItemValue(item);
                                    if ((argumentsSize += (long)value.toString().getBytes(StandardCharsets.UTF_8).length) > this.maxScriptSize) {
                                        this.onArgumentsTooBig(devPlanet, actionBlock, argumentsSize);
                                        return false;
                                    }
                                    config.saveArguments(executorBlock, notDependsOnHeight, multiActions, actionBlock, argSlot.getPath() + ".value." + i, value, CodingBlockParser.parseItemType(item));
                                }
                            }
                            slot = (byte)(slot + 1);
                        }
                        continue;
                    }
                    if (item != null) {
                        Object value = CodingBlockParser.parseItemValue(item);
                        if ((argumentsSize += (long)value.toString().getBytes(StandardCharsets.UTF_8).length) > this.maxScriptSize) {
                            this.onArgumentsTooBig(devPlanet, actionBlock, argumentsSize);
                            return false;
                        }
                        config.saveArguments(executorBlock, notDependsOnHeight, multiActions, actionBlock, argSlot.getPath(), value, CodingBlockParser.parseItemType(item));
                    }
                    slot = (byte)(slot + 1);
                }
            }
        }
        if (!unknownBlocks.isEmpty()) {
            ErrorUtils.sendPlanetCompileErrorMessage(devPlanet.getPlanet(), unknownBlocks);
            return false;
        }
        return isCodeFine;
    }

    private static ValueType parseItemType(ItemStack item) {
        ValueType valueType = ValueType.ITEM;
        if (item.getItemMeta() != null) {
            String variableType;
            PersistentDataContainer container = item.getItemMeta().getPersistentDataContainer();
            String dataType = (String)container.get(ItemUtils.getCodingValueKey(), PersistentDataType.STRING);
            if (dataType != null) {
                try {
                    valueType = ValueType.valueOf(dataType);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!(valueType != ValueType.VARIABLE && valueType != ValueType.EVENT_VALUE || (variableType = (String)container.get(ItemUtils.getCodingVariableTypeKey(), PersistentDataType.STRING)) != null && !variableType.isEmpty())) {
                return ValueType.ITEM;
            }
        }
        return valueType;
    }

    public static Object parseItemValue(ItemStack item) {
        ValueType valueType = CodingBlockParser.parseItemType(item);
        if (valueType == ValueType.ITEM) {
            return item.serialize();
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return item.serialize();
        }
        Component itemDisplayName = itemMeta.displayName();
        if (itemDisplayName == null) {
            return item.serialize();
        }
        String name = itemMeta.getDisplayName();
        switch (valueType) {
            case TEXT: {
                return name;
            }
            case BOOLEAN: {
                try {
                    boolean bool = Boolean.parseBoolean(ChatColor.stripColor((String)name));
                    return bool;
                }
                catch (Exception exception) {
                    break;
                }
            }
            case NUMBER: {
                try {
                    double number = Double.parseDouble(ChatColor.stripColor((String)name));
                    return number;
                }
                catch (Exception exception) {
                    break;
                }
            }
            case LOCATION: {
                HashMap<String, Number> locationMap = new HashMap<String, Number>();
                String locationString = ChatColor.stripColor((String)name);
                String[] locCoords = locationString.split(" ");
                if (locCoords.length != 5) break;
                try {
                    locationMap.put("x", Double.parseDouble(locCoords[0]));
                    locationMap.put("y", Double.parseDouble(locCoords[1]));
                    locationMap.put("z", Double.parseDouble(locCoords[2]));
                    locationMap.put("yaw", Float.valueOf(Float.parseFloat(locCoords[3])));
                    locationMap.put("pitch", Float.valueOf(Float.parseFloat(locCoords[4])));
                    return locationMap;
                }
                catch (Exception exception) {
                    break;
                }
            }
            case VECTOR: {
                HashMap<String, Double> vectorMap = new HashMap<String, Double>();
                String vectorString = ChatColor.stripColor((String)name);
                String[] coords = vectorString.split(" ");
                if (coords.length != 3) break;
                try {
                    vectorMap.put("x", Double.parseDouble(coords[0]));
                    vectorMap.put("y", Double.parseDouble(coords[1]));
                    vectorMap.put("z", Double.parseDouble(coords[2]));
                    return vectorMap;
                }
                catch (Exception exception) {
                    break;
                }
            }
            case COLOR: {
                HashMap<String, Integer> colorMap = new HashMap<String, Integer>();
                String colorString = ChatColor.stripColor((String)name);
                String[] colors = colorString.split(" ");
                if (colors.length != 3) break;
                try {
                    colorMap.put("red", Integer.parseInt(colors[0]));
                    colorMap.put("green", Integer.parseInt(colors[1]));
                    colorMap.put("blue", Integer.parseInt(colors[2]));
                    return colorMap;
                }
                catch (Exception exception) {
                    break;
                }
            }
            case VARIABLE: {
                PersistentDataContainer container = itemMeta.getPersistentDataContainer();
                String variableType = (String)container.get(ItemUtils.getCodingVariableTypeKey(), PersistentDataType.STRING);
                if (variableType == null) break;
                HashMap<String, String> variableMap = new HashMap<String, String>();
                try {
                    VariableLink.VariableType type = VariableLink.VariableType.valueOf(variableType);
                    variableMap.put("name", ChatColor.stripColor((String)name));
                    variableMap.put("type", type.name());
                    return variableMap;
                }
                catch (Exception exception) {
                    break;
                }
            }
            case EVENT_VALUE: {
                String variableType = ItemUtils.getPersistentData(item, ItemUtils.getCodingVariableTypeKey());
                if (variableType.startsWith("PLOT")) {
                    variableType = variableType.replace("PLOT", "PLANET");
                    ItemUtils.setPersistentData(item, ItemUtils.getCodingVariableTypeKey(), variableType);
                }
                if (!EventValues.getInstance().exists(variableType.toLowerCase())) break;
                String targetType = ItemUtils.getPersistentData(item, ItemUtils.getCodingTargetTypeKey());
                HashMap<String, String> valueMap = new HashMap<String, String>();
                valueMap.put("name", variableType);
                if (!targetType.isEmpty()) {
                    valueMap.put("target", targetType);
                }
                return valueMap;
            }
            case PARTICLE: {
                PersistentDataContainer container = itemMeta.getPersistentDataContainer();
                String particleType = (String)container.get(ItemUtils.getCodingParticleTypeKey(), PersistentDataType.STRING);
                if (particleType == null) break;
                HashMap<String, String> valueMap = new HashMap<String, String>();
                try {
                    Particle type = Particle.valueOf((String)particleType);
                    valueMap.put("type", type.name());
                    return valueMap;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return name;
    }

    private boolean isSignEmpty(Block block, byte line) {
        Block signBlock = block.getRelative(BlockFace.SOUTH);
        if (signBlock.getType().name().contains("SIGN")) {
            Sign sign = (Sign)signBlock.getState();
            if (line > 0 && line < sign.lines().size()) {
                return !sign.getLine(line - 1).isEmpty();
            }
            return false;
        }
        return false;
    }

    private void onArgumentsTooBig(DevPlanet devPlanet, Block block, long argsSize) {
        ErrorUtils.sendPlanetCompileErrorMessage(devPlanet.getPlanet(), block, MessageUtils.getLocaleMessage("world.script-size-limit").replace("%amount%", FileUtils.byteCountToDisplaySize(argsSize)).replace("%limit%", String.valueOf(this.maxScriptSize / 1024L / 1024L)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "devPlanet", "ua/mcchickenstudio/opencreative/coding/CodingBlockParser", "<init>"));
    }
}

