/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorType;
import ua.mcchickenstudio.opencreative.coding.menus.layouts.ArgumentSlot;
import ua.mcchickenstudio.opencreative.coding.values.EventValue;
import ua.mcchickenstudio.opencreative.coding.values.EventValues;
import ua.mcchickenstudio.opencreative.coding.variables.ValueType;
import ua.mcchickenstudio.opencreative.coding.variables.VariableLink;
import ua.mcchickenstudio.opencreative.listeners.player.InteractListener;
import ua.mcchickenstudio.opencreative.listeners.player.PlaceBlockListener;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.planets.DevPlatform;
import ua.mcchickenstudio.opencreative.utils.BlockUtils;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;

public class CodingBlockPlacer {
    private final Material wallSign;
    private final Material container;
    private final int blocksPerColumnLimit;
    private static final Pattern INT_PATTERN = Pattern.compile("^-?[0-9]*$");
    private static final Pattern FLOAT_PATTERN = Pattern.compile("^-?[0-9]*\\.?[0-9]+$");

    public CodingBlockPlacer(@NotNull Material wallSign, @NotNull Material container, int maximumBlocks) {
        if (wallSign == null) {
            CodingBlockPlacer.$$$reportNull$$$0(0);
        }
        if (container == null) {
            CodingBlockPlacer.$$$reportNull$$$0(1);
        }
        this.wallSign = wallSign;
        this.container = container;
        this.blocksPerColumnLimit = maximumBlocks;
    }

    public CodingBlockPlacer(@NotNull DevPlanet devPlanet) {
        if (devPlanet == null) {
            CodingBlockPlacer.$$$reportNull$$$0(2);
        }
        this(devPlanet.getSignMaterial(), devPlanet.getContainerMaterial(), devPlanet.getDevPlatformer().getCodingBlocksLimit(devPlanet));
    }

    @NotNull
    public CodePlacementResult placeCodingLines(@NotNull DevPlanet devPlanet, @NotNull ConfigurationSection blocks) {
        if (devPlanet == null) {
            CodingBlockPlacer.$$$reportNull$$$0(3);
        }
        if (blocks == null) {
            CodingBlockPlacer.$$$reportNull$$$0(4);
        }
        if (!devPlanet.isLoaded()) {
            CodePlacementResult codePlacementResult = CodePlacementResult.CANNOT_PLACE;
            if (codePlacementResult == null) {
                CodingBlockPlacer.$$$reportNull$$$0(5);
            }
            return codePlacementResult;
        }
        ArrayList<Location> freeColumns = new ArrayList<Location>();
        int requiredColumns = blocks.getKeys(false).size();
        for (DevPlatform platform : devPlanet.getPlatforms()) {
            freeColumns.addAll(platform.getFreeColumns());
            if (freeColumns.size() < requiredColumns) continue;
            break;
        }
        CodePlacementResult codePlacementResult = this.placeCodingLines(freeColumns, blocks);
        if (codePlacementResult == null) {
            CodingBlockPlacer.$$$reportNull$$$0(6);
        }
        return codePlacementResult;
    }

    @NotNull
    public CodePlacementResult placeCodingLines(@NotNull List<Location> freeColumns, @NotNull ConfigurationSection blocks) {
        int requiredColumns;
        if (freeColumns == null) {
            CodingBlockPlacer.$$$reportNull$$$0(7);
        }
        if (blocks == null) {
            CodingBlockPlacer.$$$reportNull$$$0(8);
        }
        if ((requiredColumns = blocks.getKeys(false).size()) == 0) {
            CodePlacementResult codePlacementResult = CodePlacementResult.NOTHING_TO_BUILD;
            if (codePlacementResult == null) {
                CodingBlockPlacer.$$$reportNull$$$0(9);
            }
            return codePlacementResult;
        }
        if (freeColumns.size() < requiredColumns) {
            CodePlacementResult codePlacementResult = CodePlacementResult.NOT_ENOUGH_CODING_LINES;
            if (codePlacementResult == null) {
                CodingBlockPlacer.$$$reportNull$$$0(10);
            }
            return codePlacementResult;
        }
        int columnIndex = 0;
        for (String key : blocks.getKeys(false)) {
            ConfigurationSection executorBlock = blocks.getConfigurationSection(key);
            if (executorBlock == null) continue;
            Location executorLocation = freeColumns.get(columnIndex).add(0.0, 1.0, 0.0);
            if (!this.placeExecutor(executorLocation, executorBlock)) {
                CodePlacementResult codePlacementResult = CodePlacementResult.ERROR;
                if (codePlacementResult == null) {
                    CodingBlockPlacer.$$$reportNull$$$0(11);
                }
                return codePlacementResult;
            }
            ++columnIndex;
        }
        CodePlacementResult codePlacementResult = CodePlacementResult.SUCCESSFULLY;
        if (codePlacementResult == null) {
            CodingBlockPlacer.$$$reportNull$$$0(12);
        }
        return codePlacementResult;
    }

    public boolean placeExecutor(@NotNull Location location, @NotNull ConfigurationSection data) {
        if (location == null) {
            CodingBlockPlacer.$$$reportNull$$$0(13);
        }
        if (data == null) {
            CodingBlockPlacer.$$$reportNull$$$0(14);
        }
        try {
            ConfigurationSection actions;
            if (this.blocksPerColumnLimit <= 0) {
                return false;
            }
            ExecutorType type = ExecutorType.getType(data.getString("type", ""));
            if (type != null) {
                this.buildExecutorBlock(location, type, data);
            }
            if ((actions = data.getConfigurationSection("actions")) == null) {
                return true;
            }
            Location actionLocation = location.clone();
            int blocksAmount = 1;
            for (String key : actions.getKeys(false)) {
                ConfigurationSection action = actions.getConfigurationSection(key);
                if (action == null) continue;
                actionLocation.add(2.0, 0.0, 0.0);
                if (blocksAmount > this.blocksPerColumnLimit) {
                    return false;
                }
                if (!this.placeAction(actionLocation, action, location.getBlockX() + 2 * this.blocksPerColumnLimit)) {
                    return false;
                }
                ++blocksAmount;
            }
            return true;
        }
        catch (Exception error) {
            ErrorUtils.sendDebugError("Failed to place executor block in " + location.getWorld().getName(), error);
            return false;
        }
    }

    private void buildExecutorBlock(@NotNull Location location, @NotNull ExecutorType type, @NotNull ConfigurationSection data) {
        if (location == null) {
            CodingBlockPlacer.$$$reportNull$$$0(15);
        }
        if (type == null) {
            CodingBlockPlacer.$$$reportNull$$$0(16);
        }
        if (data == null) {
            CodingBlockPlacer.$$$reportNull$$$0(17);
        }
        Location signLocation = location.getBlock().getRelative(BlockFace.SOUTH).getLocation();
        switch (type) {
            case FUNCTION: 
            case METHOD: {
                String callName = data.getString("name", "");
                PlaceBlockListener.placeDevBlock(location, type.getCategory().getBlock(), type.getCategory().getAdditionalBlock(), this.wallSign, type.getCategory().name().toLowerCase());
                BlockUtils.setSignLine(signLocation, 3, callName);
                break;
            }
            case CYCLE: {
                String cycleName = data.getString("name", "");
                int cycleRepeatingTime = data.getInt("time");
                cycleRepeatingTime = Math.clamp((long)cycleRepeatingTime, 5, 3600);
                PlaceBlockListener.placeDevBlock(location, ExecutorCategory.CYCLE.getBlock(), ExecutorCategory.CYCLE.getAdditionalBlock(), this.wallSign, "cycle");
                BlockUtils.setSignLine(signLocation, 1, cycleName);
                BlockUtils.setSignLine(signLocation, 3, String.valueOf(cycleRepeatingTime));
                break;
            }
            default: {
                PlaceBlockListener.placeDevBlock(location, type.getCategory().getBlock(), type.getCategory().getAdditionalBlock(), this.wallSign, type.getCategory().name().toLowerCase());
                BlockUtils.setSignLine(signLocation, 3, type.name().toLowerCase());
            }
        }
    }

    private boolean placeAction(@NotNull Location location, @NotNull ConfigurationSection data, int maximumX) {
        if (location == null) {
            CodingBlockPlacer.$$$reportNull$$$0(18);
        }
        if (data == null) {
            CodingBlockPlacer.$$$reportNull$$$0(19);
        }
        try {
            ActionType type = ActionType.getType(data.getString("type", ""));
            if (type == null) {
                return true;
            }
            this.buildContainerBlock(location, data, type);
            this.buildActionBlock(location, data, type, maximumX);
        }
        catch (Exception error) {
            ErrorUtils.sendDebugError("Cannot place action block.", error);
            return false;
        }
        return true;
    }

    private void buildContainerBlock(@NotNull Location location, @NotNull ConfigurationSection data, @NotNull ActionType type) {
        ConfigurationSection arguments;
        if (location == null) {
            CodingBlockPlacer.$$$reportNull$$$0(20);
        }
        if (data == null) {
            CodingBlockPlacer.$$$reportNull$$$0(21);
        }
        if (type == null) {
            CodingBlockPlacer.$$$reportNull$$$0(22);
        }
        if ((arguments = data.getConfigurationSection("arguments")) != null && type.isChestRequired()) {
            Block containerBlock = location.getBlock().getRelative(BlockFace.UP);
            containerBlock.setType(this.container);
            BlockData blockData = containerBlock.getBlockData();
            ((Directional)blockData).setFacing(BlockFace.SOUTH);
            containerBlock.setBlockData(blockData);
            BlockState blockState = containerBlock.getState();
            if (blockState instanceof InventoryHolder) {
                InventoryHolder holder = (InventoryHolder)blockState;
                int slot = -1;
                for (ArgumentSlot argSlot : type.getArgumentsSlots()) {
                    ConfigurationSection argSection = arguments.getConfigurationSection(argSlot.getPath());
                    if (argSection == null) continue;
                    if (argSlot.isList()) {
                        for (int i = 1; i <= argSlot.getListSize(); ++i) {
                            ++slot;
                            ConfigurationSection valueSection = argSection.getConfigurationSection("value." + i + ".value");
                            Object valueObject = argSection.get("value." + i + ".value");
                            String valueTypeString = argSection.getString("value." + i + ".type");
                            if (valueObject == null || valueTypeString == null) continue;
                            ValueType valueType = ValueType.parseString(valueTypeString);
                            holder.getInventory().setItem(slot, this.getItem(valueType, valueSection, valueObject, false));
                        }
                        continue;
                    }
                    ++slot;
                    ConfigurationSection valueSection = argSection.getConfigurationSection("value");
                    Object valueObject = argSection.get("value");
                    String valueTypeString = argSection.getString("type");
                    if (valueObject == null || valueTypeString == null) continue;
                    ValueType valueType = ValueType.parseString(valueTypeString);
                    holder.getInventory().setItem(slot, this.getItem(valueType, valueSection, valueObject, argSlot.isParameter()));
                }
            }
        }
    }

    private void buildActionBlock(@NotNull Location location, @NotNull ConfigurationSection data, @NotNull ActionType type, int maximumX) {
        if (location == null) {
            CodingBlockPlacer.$$$reportNull$$$0(23);
        }
        if (data == null) {
            CodingBlockPlacer.$$$reportNull$$$0(24);
        }
        if (type == null) {
            CodingBlockPlacer.$$$reportNull$$$0(25);
        }
        Location signLocation = location.getBlock().getRelative(BlockFace.SOUTH).getLocation();
        String target = data.getString("target", "").toLowerCase();
        switch (type) {
            case LAUNCH_FUNCTION: 
            case LAUNCH_METHOD: {
                PlaceBlockListener.placeDevBlock(location, type.getCategory().getBlock(), type.getCategory().getAdditionalBlock(), this.wallSign, type.getCategory().name().toLowerCase());
                String name = data.getString("name", "");
                BlockUtils.setSignLine(signLocation, 3, name);
                BlockUtils.setSignLine(signLocation, 4, target);
                break;
            }
            case SELECTION_SET: 
            case SELECTION_ADD: 
            case SELECTION_REMOVE: {
                PlaceBlockListener.placeDevBlock(location, type.getCategory().getBlock(), type.getCategory().getAdditionalBlock(), this.wallSign, "");
                ConfigurationSection conditionInfo = data.getConfigurationSection("condition");
                if (conditionInfo != null) {
                    boolean isOpposed = conditionInfo.getBoolean("opposed", false);
                    ActionCategory conditionCategory = ActionCategory.valueOf(conditionInfo.getString("category"));
                    ActionType conditionType = ActionType.valueOf(conditionInfo.getString("type"));
                    if (isOpposed) {
                        BlockUtils.setSignLine(signLocation, 1, "not");
                    }
                    BlockUtils.setSignLine(signLocation, 2, conditionCategory.name().toLowerCase());
                    BlockUtils.setSignLine(signLocation, 3, conditionType.name().toLowerCase());
                    break;
                }
                BlockUtils.setSignLine(signLocation, 2, target);
                break;
            }
            default: {
                PlaceBlockListener.placeDevBlock(location, type.getCategory().getBlock(), type.getCategory().getAdditionalBlock(), this.wallSign, type.getCategory().name().toLowerCase());
                BlockUtils.setSignLine(signLocation, 3, type.name().toLowerCase());
                BlockUtils.setSignLine(signLocation, 4, target);
                if (type.getCategory().isCondition() && data.getBoolean("opposed", false)) {
                    BlockUtils.setSignLine(signLocation, 1, "not");
                }
                if (!type.getCategory().isMultiAction()) break;
                this.buildMultiActionBlock(location, data, maximumX);
            }
        }
    }

    private void buildMultiActionBlock(@NotNull Location location, @NotNull ConfigurationSection data, int maximumX) {
        ConfigurationSection elseActions;
        ConfigurationSection actions;
        if (location == null) {
            CodingBlockPlacer.$$$reportNull$$$0(26);
        }
        if (data == null) {
            CodingBlockPlacer.$$$reportNull$$$0(27);
        }
        if ((actions = data.getConfigurationSection("actions")) != null) {
            for (String key : actions.getKeys(false)) {
                if (location.getBlockX() + 2 > maximumX) {
                    return;
                }
                location.add(2.0, 0.0, 0.0);
                ConfigurationSection action = actions.getConfigurationSection(key);
                if (action == null) continue;
                this.placeAction(location, action, maximumX);
            }
            this.addEndingPiston(location);
        }
        if ((elseActions = data.getConfigurationSection("else")) != null) {
            PlaceBlockListener.placeDevBlock(location.add(2.0, 0.0, 0.0), ActionCategory.ELSE_CONDITION.getBlock(), ActionCategory.ELSE_CONDITION.getAdditionalBlock(), this.wallSign, "else_condition");
            for (String key : elseActions.getKeys(false)) {
                if (location.getBlockX() + 2 > maximumX) {
                    return;
                }
                location.add(2.0, 0.0, 0.0);
                ConfigurationSection action = elseActions.getConfigurationSection(key);
                if (action == null) continue;
                this.placeAction(location, action, maximumX);
            }
            this.addEndingPiston(location);
        }
    }

    @NotNull
    private ItemStack getItem(@NotNull ValueType type, @Nullable ConfigurationSection data, @NotNull Object configValue, boolean doNotDropMe) {
        if (type == null) {
            CodingBlockPlacer.$$$reportNull$$$0(28);
        }
        if (configValue == null) {
            CodingBlockPlacer.$$$reportNull$$$0(29);
        }
        String stringValue = configValue.toString();
        ItemStack item = ItemUtils.createItem(type.getMaterial(), 1, "menus.developer.variables.items." + type.name().toLowerCase().replace("_", "-"));
        if (doNotDropMe) {
            ItemUtils.setPersistentData(item, ItemUtils.getCodingDoNotDropMeKey(), "1");
        }
        ItemMeta meta = item.getItemMeta();
        switch (type) {
            case LOCATION: {
                if (data == null) {
                    return new ItemStack(Material.AIR);
                }
                double x = data.getDouble("x");
                double y = data.getDouble("y");
                double z = data.getDouble("z");
                float yaw = (float)data.getDouble("yaw");
                float pitch = (float)data.getDouble("pitch");
                Location location = new Location(null, x, y, z, yaw, pitch);
                ItemUtils.setDisplayName(item, InteractListener.formatLocation(location));
                ItemUtils.setPersistentData(item, ItemUtils.getCodingValueKey(), "LOCATION");
                ItemStack itemStack = item;
                if (itemStack == null) {
                    CodingBlockPlacer.$$$reportNull$$$0(30);
                }
                return itemStack;
            }
            case VECTOR: {
                if (data == null) {
                    return new ItemStack(Material.AIR);
                }
                double x = data.getDouble("x");
                double y = data.getDouble("y");
                double z = data.getDouble("z");
                ItemUtils.setDisplayName(item, ChatColor.translateAlternateColorCodes((char)'&', (String)("&b" + x + " " + y + " " + z)));
                ItemUtils.setPersistentData(item, ItemUtils.getCodingValueKey(), "VECTOR");
                ItemStack itemStack = item;
                if (itemStack == null) {
                    CodingBlockPlacer.$$$reportNull$$$0(31);
                }
                return itemStack;
            }
            case COLOR: {
                if (data == null) {
                    return new ItemStack(Material.AIR);
                }
                int r = data.getInt("red");
                int g = data.getInt("blue");
                int b = data.getInt("green");
                if (meta != null) {
                    meta.displayName(Component.text((String)(r + " " + g + " " + b)).color(TextColor.color((int)r, (int)g, (int)b)));
                    item.setItemMeta(meta);
                }
                ItemUtils.setPersistentData(item, ItemUtils.getCodingValueKey(), "COLOR");
                ItemStack itemStack = item;
                if (itemStack == null) {
                    CodingBlockPlacer.$$$reportNull$$$0(32);
                }
                return itemStack;
            }
            case VARIABLE: {
                if (data == null) {
                    return new ItemStack(Material.AIR);
                }
                String varName = data.getString("name", "");
                String typeString = data.getString("type");
                VariableLink.VariableType varType = VariableLink.VariableType.getEnum(typeString);
                if (varType == null) {
                    varType = VariableLink.VariableType.GLOBAL;
                }
                ItemUtils.setDisplayName(item, String.valueOf(varType.getColor()) + varName);
                ItemUtils.setPersistentData(item, ItemUtils.getCodingValueKey(), "VARIABLE");
                ItemUtils.setPersistentData(item, ItemUtils.getCodingVariableTypeKey(), varType.name());
                ItemStack itemStack = item;
                if (itemStack == null) {
                    CodingBlockPlacer.$$$reportNull$$$0(33);
                }
                return itemStack;
            }
            case EVENT_VALUE: {
                EventValue eventValue;
                if (data == null) {
                    return new ItemStack(Material.AIR);
                }
                String valueType = data.getString("name");
                String targetType = data.getString("target", "selected");
                if (valueType == null) {
                    return new ItemStack(Material.AIR);
                }
                if (valueType.isEmpty()) {
                    return new ItemStack(Material.AIR);
                }
                Target target = Target.getByText(targetType);
                if (valueType.startsWith("PLOT")) {
                    valueType = valueType.replace("PLOT", "PLANET");
                }
                if ((eventValue = EventValues.getInstance().getById(valueType.toLowerCase())) != null) {
                    ItemUtils.setDisplayName(item, eventValue.getLocaleName());
                } else {
                    ItemUtils.setDisplayName(item, valueType);
                }
                ItemUtils.setPersistentData(item, ItemUtils.getCodingValueKey(), "EVENT_VALUE");
                ItemUtils.setPersistentData(item, ItemUtils.getCodingVariableTypeKey(), valueType);
                ItemUtils.setPersistentData(item, ItemUtils.getCodingTargetTypeKey(), target.name());
                ItemStack itemStack = item;
                if (itemStack == null) {
                    CodingBlockPlacer.$$$reportNull$$$0(34);
                }
                return itemStack;
            }
            case NUMBER: {
                if (INT_PATTERN.matcher(stringValue).matches()) {
                    ItemUtils.setDisplayName(item, ChatColor.translateAlternateColorCodes((char)'&', (String)("&a" + Integer.parseInt(stringValue))));
                } else if (FLOAT_PATTERN.matcher(stringValue).matches()) {
                    ItemUtils.setDisplayName(item, ChatColor.translateAlternateColorCodes((char)'&', (String)("&a" + Float.parseFloat(stringValue))));
                }
                ItemUtils.setPersistentData(item, ItemUtils.getCodingValueKey(), "NUMBER");
                ItemStack itemStack = item;
                if (itemStack == null) {
                    CodingBlockPlacer.$$$reportNull$$$0(35);
                }
                return itemStack;
            }
            case TEXT: {
                ItemUtils.setDisplayName(item, stringValue);
                ItemUtils.setPersistentData(item, ItemUtils.getCodingValueKey(), "TEXT");
                ItemStack itemStack = item;
                if (itemStack == null) {
                    CodingBlockPlacer.$$$reportNull$$$0(36);
                }
                return itemStack;
            }
            case BOOLEAN: {
                boolean value = Boolean.parseBoolean(stringValue);
                ItemUtils.setDisplayName(item, ChatColor.translateAlternateColorCodes((char)'&', (String)((value ? "&a" : "&c") + value)));
                ItemUtils.setPersistentData(item, ItemUtils.getCodingValueKey(), "BOOLEAN");
                ItemStack itemStack = item;
                if (itemStack == null) {
                    CodingBlockPlacer.$$$reportNull$$$0(37);
                }
                return itemStack;
            }
            case PARTICLE: {
                if (data == null) {
                    return new ItemStack(Material.AIR);
                }
                String particle = data.getString("type");
                ItemUtils.setPersistentData(item, ItemUtils.getCodingValueKey(), "PARTICLE");
                ItemUtils.setPersistentData(item, ItemUtils.getCodingParticleTypeKey(), particle);
                ItemStack itemStack = item;
                if (itemStack == null) {
                    CodingBlockPlacer.$$$reportNull$$$0(38);
                }
                return itemStack;
            }
            case ITEM: 
            case ANY: 
            case POTION: {
                if (data == null) {
                    return new ItemStack(Material.AIR);
                }
                ItemStack itemStack = ItemStack.deserialize((Map)data.getValues(false));
                if (itemStack == null) {
                    CodingBlockPlacer.$$$reportNull$$$0(39);
                }
                return itemStack;
            }
        }
        return new ItemStack(Material.AIR);
    }

    private void addEndingPiston(@NotNull Location location) {
        if (location == null) {
            CodingBlockPlacer.$$$reportNull$$$0(40);
        }
        location.add(3.0, 0.0, 0.0);
        Block farEastBlock = location.getBlock();
        farEastBlock.setType(Material.PISTON);
        Directional data = (Directional)farEastBlock.getBlockData();
        data.setFacing(BlockFace.WEST);
        farEastBlock.setBlockData((BlockData)data);
        location.add(-1.0, 0.0, 0.0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 9, 10, 11, 12, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wallSign";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devPlanet";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blocks";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/coding/CodingBlockPlacer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "freeColumns";
                break;
            }
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 23: 
            case 26: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 16: 
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/coding/CodingBlockPlacer";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "placeCodingLines";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "placeCodingLines";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "placeExecutor";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildExecutorBlock";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "placeAction";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "buildContainerBlock";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "buildActionBlock";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "buildMultiActionBlock";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getItem";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addEndingPiston";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 9, 10, 11, 12, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39 -> new IllegalStateException(string);
        };
    }

    public static enum CodePlacementResult {
        SUCCESSFULLY,
        NOTHING_TO_BUILD,
        ERROR,
        CANNOT_PLACE,
        NOT_ENOUGH_CODING_LINES;


        public boolean isSuccess() {
            return this == SUCCESSFULLY || this == NOTHING_TO_BUILD;
        }
    }
}

