/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.planets.Planet;

public abstract class CreativeRunnable {
    private final Planet planet;
    private int id;

    public CreativeRunnable(Planet planet) {
        this.planet = planet;
    }

    public abstract void execute(Player var1);

    public synchronized void runTaskTimer(final List<Player> onlinePlayers, long period, long timer) {
        final ArrayList<Player> currentPlayers = new ArrayList<Player>(onlinePlayers);
        this.id = new BukkitRunnable(){

            public void run() {
                if (CreativeRunnable.this.planet != null && CreativeRunnable.this.planet.getMode() == Planet.Mode.PLAYING) {
                    for (Player player : onlinePlayers) {
                        if (currentPlayers.isEmpty()) {
                            this.cancel();
                        }
                        if (CreativeRunnable.this.planet.getMode() != Planet.Mode.PLAYING) {
                            this.cancel();
                        }
                        if (player == null) continue;
                        if (!player.isOnline()) {
                            currentPlayers.remove(player);
                            continue;
                        }
                        Planet playerPlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
                        if (!CreativeRunnable.this.planet.equals(playerPlanet)) {
                            currentPlayers.remove(player);
                            continue;
                        }
                        DevPlanet playerDevPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
                        if (playerDevPlanet != null) {
                            currentPlayers.remove(player);
                            continue;
                        }
                        CreativeRunnable.this.execute(player);
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)OpenCreative.getPlugin(), period, timer).getTaskId();
    }

    public synchronized void runTaskLater(final List<Player> onlinePlayers, long delay) {
        final ArrayList<Player> currentPlayers = new ArrayList<Player>(onlinePlayers);
        this.id = new BukkitRunnable(){

            public void run() {
                if (CreativeRunnable.this.planet != null && CreativeRunnable.this.planet.getMode() == Planet.Mode.PLAYING) {
                    for (Player player : onlinePlayers) {
                        if (currentPlayers.isEmpty()) {
                            this.cancel();
                        }
                        if (CreativeRunnable.this.planet.getMode() != Planet.Mode.PLAYING) {
                            this.cancel();
                        }
                        if (player == null) continue;
                        if (!player.isOnline()) {
                            currentPlayers.remove(player);
                            continue;
                        }
                        Planet playerPlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
                        if (!CreativeRunnable.this.planet.equals(playerPlanet)) {
                            currentPlayers.remove(player);
                            continue;
                        }
                        DevPlanet playerDevPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
                        if (playerDevPlanet != null) {
                            currentPlayers.remove(player);
                            continue;
                        }
                        CreativeRunnable.this.execute(player);
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskLater((Plugin)OpenCreative.getPlugin(), delay).getTaskId();
    }

    public synchronized void cancel() {
        Bukkit.getScheduler().cancelTask(this.id);
    }
}

