/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.coding.arguments.Argument;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionsHandler;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.selectionactions.SelectionAction;
import ua.mcchickenstudio.opencreative.coding.blocks.events.WorldEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.fighting.KillerVictimEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.coding.exceptions.TooLongTextException;
import ua.mcchickenstudio.opencreative.coding.variables.ValueType;
import ua.mcchickenstudio.opencreative.coding.variables.VariableLink;
import ua.mcchickenstudio.opencreative.listeners.player.ChangedWorld;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;

public abstract class Action {
    private final Executor executor;
    private final Target target;
    private final int x;
    protected Entity entity;
    protected WorldEvent event;
    protected ActionsHandler handler;
    protected final Arguments arguments;
    protected final String EMPTY_STRING = "";

    public Action(Executor executor, Target target, int x, Arguments args) {
        this.executor = executor;
        this.target = target;
        this.x = x;
        this.arguments = args;
    }

    public void prepareAndExecute(ActionsHandler handler) {
        if (this.getActionType() != null && this.getActionType().isDisabled()) {
            ErrorUtils.sendCodingDebugLog(this.getPlanet(), "Action is disabled, cannot work: " + this.getActionType().getLocaleName());
            return;
        }
        this.handler = handler;
        this.event = handler.getEvent();
        ErrorUtils.sendCodingDebugAction(this);
        if (this instanceof SelectionAction) {
            this.execute(null);
        }
        for (Entity entity : this.getTargets()) {
            if (this.getActionType().isSelectionMustBeInWorld() && (entity == null || entity.getWorld() != this.getPlanet().getTerritory().getWorld())) continue;
            this.entity = entity;
            this.execute(entity);
        }
    }

    protected abstract void execute(Entity var1);

    public abstract ActionType getActionType();

    public abstract ActionCategory getActionCategory();

    protected final Arguments getArguments() {
        return this.arguments;
    }

    public final Executor getExecutor() {
        return this.executor;
    }

    public final int getX() {
        return this.x;
    }

    protected Set<Entity> getEntitiesByNameOrUUID(String text) {
        HashSet<Entity> entities = new HashSet<Entity>();
        if (this.getWorld() == null) {
            return entities;
        }
        for (Entity entity : this.executor.getPlanet().getTerritory().getWorld().getEntities()) {
            if (!entity.getName().equalsIgnoreCase(text) && !entity.getUniqueId().toString().equalsIgnoreCase(text)) continue;
            entities.add(entity);
        }
        return entities;
    }

    protected Set<Player> getPlayersByNameOrUUID(String text) {
        HashSet<Player> players = new HashSet<Player>();
        if (this.getWorld() == null) {
            return players;
        }
        for (Player player : this.getWorld().getPlayers()) {
            if (!player.getName().equalsIgnoreCase(text) && !player.getUniqueId().toString().equalsIgnoreCase(text)) continue;
            players.add(player);
        }
        return players;
    }

    protected World getWorld() {
        return this.getPlanet().getTerritory().getWorld();
    }

    protected Planet getPlanet() {
        return this.executor.getPlanet();
    }

    public Entity getEntity() {
        return this.entity;
    }

    public WorldEvent getEvent() {
        return this.event;
    }

    public ActionsHandler getHandler() {
        return this.handler;
    }

    public Target getTarget() {
        return this.target;
    }

    protected List<Entity> getTargets() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        List<Entity> eventEntities = this.getHandler().getEvent().getSelection();
        switch (this.target) {
            case RANDOM_PLAYER: {
                Player randomPlayer = null;
                List playerList = this.getExecutor().getPlanet().getTerritory().getWorld().getPlayers();
                if (!playerList.isEmpty()) {
                    Random r = new Random();
                    int i = r.nextInt(playerList.size());
                    randomPlayer = (Player)playerList.get(i);
                }
                if (randomPlayer == null) break;
                entities.add((Entity)randomPlayer);
                break;
            }
            case ALL_PLAYERS: {
                List playerList = this.getExecutor().getPlanet().getTerritory().getWorld().getPlayers();
                if (playerList.isEmpty()) break;
                entities.addAll(playerList);
                break;
            }
            case KILLER: {
                Entity killer = this.getKiller();
                if (killer == null) break;
                entities.add(killer);
                break;
            }
            case VICTIM: {
                Entity victim = this.getVictim();
                if (victim == null) break;
                entities.add(victim);
                break;
            }
            case SELECTED: {
                entities.addAll(this.getHandler().getSelectedTargets());
                break;
            }
            case ALL_ENTITIES: {
                for (Entity entity2 : this.getWorld().getEntities()) {
                    if (entity2 instanceof Player) continue;
                    entities.add(entity2);
                }
                break;
            }
            case RANDOM_TARGET: {
                ArrayList<Entity> selectedTargets = new ArrayList<Entity>(this.getHandler().getSelectedTargets());
                if (selectedTargets.isEmpty()) break;
                entities.add((Entity)selectedTargets.get(new Random().nextInt(selectedTargets.size())));
                break;
            }
            default: {
                entities.addAll(eventEntities);
            }
        }
        entities.removeIf(entity -> {
            Player player;
            return entity instanceof Player && ChangedWorld.isPlayerWithLocation(player = (Player)entity);
        });
        entities.removeIf(entity -> !entity.getWorld().equals((Object)this.getPlanet().getWorld()));
        return entities;
    }

    private Entity getVictim() {
        WorldEvent worldEvent = this.executor.getEvent();
        if (worldEvent instanceof KillerVictimEvent) {
            KillerVictimEvent victimEvent = (KillerVictimEvent)((Object)worldEvent);
            return victimEvent.getVictim();
        }
        return null;
    }

    private Entity getKiller() {
        WorldEvent worldEvent = this.executor.getEvent();
        if (worldEvent instanceof KillerVictimEvent) {
            KillerVictimEvent mobEvent = (KillerVictimEvent)((Object)worldEvent);
            return mobEvent.getKiller();
        }
        return null;
    }

    protected void setVarValue(@Nullable VariableLink link, Object value) {
        if (link != null) {
            String text;
            ValueType type = ValueType.getByObject(value);
            if (type == null) {
                type = ValueType.TEXT;
            }
            if (value instanceof String && (text = (String)value).length() > 1024) {
                throw new TooLongTextException(1024);
            }
            this.getPlanet().getVariables().setVariableValue(link, type, value, this.getHandler().getMainActionHandler(), this);
        }
    }

    public void setHandler(ActionsHandler handler) {
        this.handler = handler;
    }

    public List<Argument> getArgumentsList() {
        return this.getArguments().getArgumentList();
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }
}

