/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions;

import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.coding.menus.MenusCategory;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public enum ActionCategory {
    PLAYER_ACTION(Material.COBBLESTONE, Material.STONE, NamedTextColor.GRAY, Material.GRAY_STAINED_GLASS_PANE, MenusCategory.COMMUNICATION),
    ENTITY_ACTION(Material.MOSSY_COBBLESTONE, Material.STONE, NamedTextColor.GREEN, Material.GREEN_STAINED_GLASS_PANE, MenusCategory.ENTITY_PARAMS),
    WORLD_ACTION(Material.NETHER_BRICKS, Material.NETHERRACK, NamedTextColor.RED, Material.RED_STAINED_GLASS_PANE, MenusCategory.WORLD),
    VARIABLE_ACTION(Material.IRON_BLOCK, Material.IRON_ORE, NamedTextColor.WHITE, Material.WHITE_STAINED_GLASS_PANE, MenusCategory.OTHER),
    SELECTION_ACTION(Material.PURPUR_BLOCK, Material.PURPUR_PILLAR, NamedTextColor.LIGHT_PURPLE, Material.PINK_STAINED_GLASS_PANE),
    LAUNCH_FUNCTION_ACTION(Material.LAPIS_ORE, Material.STONE, NamedTextColor.AQUA, Material.BLUE_STAINED_GLASS_PANE),
    LAUNCH_METHOD_ACTION(Material.EMERALD_ORE, Material.STONE, NamedTextColor.GREEN, Material.LIME_STAINED_GLASS_PANE),
    CONTROL_ACTION(Material.COAL_BLOCK, Material.COAL_ORE, NamedTextColor.DARK_GRAY, Material.GRAY_STAINED_GLASS_PANE, MenusCategory.LINES),
    CONTROLLER_ACTION(Material.DARK_PRISMARINE, Material.PISTON, NamedTextColor.GREEN, Material.BLUE_STAINED_GLASS_PANE, MenusCategory.CONTROLLER),
    REPEAT_ACTION(Material.PRISMARINE, Material.PISTON, NamedTextColor.AQUA, Material.LIGHT_BLUE_STAINED_GLASS_PANE, MenusCategory.REPEATS),
    PLAYER_CONDITION(Material.OAK_PLANKS, Material.PISTON, NamedTextColor.GOLD, Material.ORANGE_STAINED_GLASS_PANE, MenusCategory.PARAMS),
    VARIABLE_CONDITION(Material.OBSIDIAN, Material.PISTON, NamedTextColor.BLUE, Material.BLUE_STAINED_GLASS_PANE, MenusCategory.OTHER),
    WORLD_CONDITION(Material.RED_NETHER_BRICKS, Material.PISTON, NamedTextColor.RED, Material.RED_STAINED_GLASS_PANE, MenusCategory.BLOCKS),
    ENTITY_CONDITION(Material.BRICKS, Material.PISTON, NamedTextColor.RED, Material.RED_STAINED_GLASS_PANE, MenusCategory.ENTITY_INTERACTION),
    ELSE_CONDITION(Material.END_STONE, Material.PISTON, NamedTextColor.YELLOW, Material.YELLOW_STAINED_GLASS_PANE);

    private final Material block;
    private final Material additionalBlock;
    private final NamedTextColor color;
    private final Material stainedPane;
    private final MenusCategory defaultCategory;

    private ActionCategory(Material block, Material additionalBlock, NamedTextColor color, Material stainedPane) {
        this(block, additionalBlock, color, stainedPane, MenusCategory.OTHER);
    }

    private ActionCategory(Material block, Material additionalBlock, NamedTextColor color, Material stainedPane, MenusCategory defaultCategory) {
        this.block = block;
        this.additionalBlock = additionalBlock;
        this.color = color;
        this.stainedPane = stainedPane;
        this.defaultCategory = defaultCategory;
    }

    public MenusCategory getDefaultCategory() {
        return this.defaultCategory;
    }

    public static ActionCategory getByMaterial(Material material) {
        for (ActionCategory category : ActionCategory.values()) {
            if (category.block != material) continue;
            return category;
        }
        return null;
    }

    public boolean isMultiAction() {
        return this.additionalBlock == Material.PISTON;
    }

    public boolean isCondition() {
        return this == PLAYER_CONDITION || this == VARIABLE_CONDITION || this == WORLD_CONDITION || this == ENTITY_CONDITION || this == ELSE_CONDITION;
    }

    public NamedTextColor getColor() {
        return this.color;
    }

    public final String getLocaleName() {
        return MessageUtils.getLocaleMessage("blocks." + this.name().toLowerCase(), false);
    }

    public Material getStainedPane() {
        return this.stainedPane;
    }

    public Material getAdditionalBlock() {
        return this.additionalBlock;
    }

    public Material getBlock() {
        return this.block;
    }

    public ItemStack getItem() {
        return ItemUtils.createItem(this.block, 1, "items.developer." + this.name().toLowerCase().replace("_", "-"), this.name().toLowerCase());
    }
}

