/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.controlactions.lines.WaitAction;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.controlleractions.other.MeasureTimeAction;
import ua.mcchickenstudio.opencreative.coding.blocks.events.WorldEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.coding.exceptions.PlayerException;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class ActionsHandler {
    private final Executor executor;
    private final WorldEvent event;
    private final Action action;
    private final Set<Entity> selectedTargets;
    private final ActionsHandler parentActionsHandler;
    private final Queue<Action> actionsQueue = new LinkedList<Action>();
    private final boolean doNotUseTryFlag;
    private boolean stopped = false;
    private long waitDelay = 0L;

    public ActionsHandler(Executor executor) {
        this.executor = executor;
        this.event = executor.getEvent();
        this.selectedTargets = new HashSet<Entity>(this.event.getSelection());
        this.parentActionsHandler = null;
        this.action = null;
        this.doNotUseTryFlag = false;
    }

    public ActionsHandler(Action action) {
        this.parentActionsHandler = action.getHandler();
        ActionsHandler mainHandler = this.getMainActionHandler();
        this.executor = mainHandler.executor;
        this.event = mainHandler.event;
        this.action = action;
        this.selectedTargets = new HashSet<Entity>(this.parentActionsHandler.selectedTargets);
        this.doNotUseTryFlag = action.getActionType() == ActionType.CONTROLLER_CATCH_ERROR || this.parentActionsHandler.doNotUseTryFlag;
    }

    public final void executeActions(List<Action> actions) {
        this.actionsQueue.addAll(actions);
        this.executeNextAction();
    }

    public final void addActions(List<Action> actions) {
        ArrayList<Action> current = new ArrayList<Action>(this.actionsQueue);
        this.actionsQueue.clear();
        this.actionsQueue.addAll(actions);
        this.actionsQueue.addAll(current);
    }

    private void executeNextAction() {
        if (this.executor.getPlanet().getMode() != Planet.Mode.PLAYING) {
            this.actionsQueue.clear();
            return;
        }
        if (this.actionsQueue.isEmpty()) {
            Action action = this.action;
            if (action instanceof MeasureTimeAction) {
                MeasureTimeAction timer = (MeasureTimeAction)action;
                timer.measure();
            }
            if (this.getMainActionHandler() == this) {
                this.executor.getPlanet().getVariables().garbageCollector(this);
            }
            return;
        }
        Action nextAction = this.actionsQueue.poll();
        if (nextAction != null) {
            this.prepareAction(nextAction);
        }
    }

    public void prepareAction(final Action action) {
        if (this.waitDelay < 1L) {
            this.executeAction(action);
        } else {
            BukkitRunnable executeActionLaterRunnable = new BukkitRunnable(){

                public void run() {
                    if (action == null || action.getPlanet() == null || action.getPlanet().getMode() != Planet.Mode.PLAYING || !action.getPlanet().isLoaded()) {
                        this.cancel();
                    }
                    if (action != null) {
                        ActionsHandler.this.executeAction(action);
                        action.getPlanet().getTerritory().removeBukkitRunnable(this);
                    }
                }
            };
            action.getPlanet().getTerritory().addBukkitRunnable(executeActionLaterRunnable);
            executeActionLaterRunnable.runTaskLater((Plugin)OpenCreative.getPlugin(), this.waitDelay);
        }
    }

    private void executeAction(Action action) {
        if (!this.stopped) {
            if (this.doNotUseTryFlag) {
                action.prepareAndExecute(this);
            } else {
                try {
                    action.prepareAndExecute(this);
                }
                catch (Exception error) {
                    String string;
                    String id = error.getClass().getSimpleName().toLowerCase();
                    String string2 = MessageUtils.getLocaleMessage("coding-error." + (MessageUtils.messageExists("coding-error." + id) ? id : "unknown"));
                    if (error instanceof PlayerException) {
                        PlayerException playerException = (PlayerException)error;
                        string = playerException.getPlayerName();
                    } else {
                        string = "";
                    }
                    ErrorUtils.sendPlanetCodeErrorMessage(this.executor, action, string2.replace("%player%", string) + (error.getMessage() == null ? error.getClass().getSimpleName() : error.getMessage()).replace("ua.mcchickenstudio.opencreative.coding.", ""), error);
                    this.removeAllActions();
                }
            }
        }
        if (!(action instanceof WaitAction)) {
            this.setWaitDelay(0L);
        } else {
            this.setWaitDelay(((WaitAction)action).getTime());
        }
        this.executeNextAction();
    }

    public void removeAllActions() {
        this.actionsQueue.clear();
    }

    public long getWaitDelay() {
        return this.waitDelay;
    }

    public ActionsHandler getMainActionHandler() {
        ActionsHandler lastHandler = this;
        for (ActionsHandler handler = this.getParentActionHandler(); handler != null; handler = handler.getParentActionHandler()) {
            lastHandler = handler;
        }
        return lastHandler;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    public ActionsHandler getParentActionHandler() {
        return this.parentActionsHandler;
    }

    public void setWaitDelay(long waitDelay) {
        this.waitDelay = waitDelay;
    }

    public WorldEvent getEvent() {
        return this.event;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public String toString() {
        return "ActionsHandler. Planet: " + String.valueOf(this.executor.getPlanet()) + " WaitDelay: " + this.waitDelay + " Stopped: " + this.stopped + " Queue Size: " + this.actionsQueue.size();
    }

    public Set<Entity> getSelectedTargets() {
        return this.selectedTargets;
    }
}

