/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.entityactions.inventory;

import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.entityactions.EntityAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.coding.variables.VariableLink;

public final class EntityGetItemAction
extends EntityAction {
    public EntityGetItemAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    public void execute(Entity entity) {
        LivingEntity living;
        VariableLink link = this.getArguments().getVariableLink("variable", this);
        int index = this.getArguments().getValue("slot", 1, (Action)this);
        ItemStack item = null;
        if (entity instanceof InventoryHolder) {
            InventoryHolder holder = (InventoryHolder)entity;
            item = holder.getInventory().getItem(index - 1);
        } else if (entity instanceof LivingEntity && (living = (LivingEntity)entity).getEquipment() != null) {
            item = living.getEquipment().getItem(EquipmentSlot.values()[index - 1]);
        }
        if (item != null) {
            this.setVarValue(link, item);
        }
    }

    @Override
    public ActionType getActionType() {
        return ActionType.ENTITY_GET_ITEM_BY_SLOT;
    }
}

