/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.entityactions.inventory;

import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.entityactions.EntityAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public final class EntityRemoveItemsAction
extends EntityAction {
    public EntityRemoveItemsAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    public void execute(Entity entity) {
        LivingEntity living;
        if (entity instanceof InventoryHolder) {
            InventoryHolder holder = (InventoryHolder)entity;
            for (ItemStack item : this.getArguments().getItemList("items", this)) {
                holder.getInventory().removeItemAnySlot(new ItemStack[]{item});
            }
        } else if (entity instanceof LivingEntity && (living = (LivingEntity)entity).getEquipment() != null) {
            ItemStack[] armor = living.getEquipment().getArmorContents();
            for (ItemStack item : this.getArguments().getItemList("items", this)) {
                for (int i = 0; i < armor.length; ++i) {
                    if (armor[i] == null || !armor[i].isSimilar(item)) continue;
                    armor[i] = null;
                }
            }
            living.getEquipment().setArmorContents(armor);
        }
    }

    @Override
    public ActionType getActionType() {
        return ActionType.ENTITY_REMOVE_ITEMS;
    }
}

