/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.entityactions.inventory;

import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.entityactions.EntityAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public final class EntitySetArmorAction
extends EntityAction {
    public EntitySetArmorAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    public void execute(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (living.getEquipment() == null) {
            return;
        }
        ItemStack helmet = this.getArguments().getValue("helmet", ItemStack.empty(), (Action)this);
        ItemStack chestplate = this.getArguments().getValue("chestplate", ItemStack.empty(), (Action)this);
        ItemStack leggings = this.getArguments().getValue("leggings", ItemStack.empty(), (Action)this);
        ItemStack boots = this.getArguments().getValue("boots", ItemStack.empty(), (Action)this);
        boolean replaceWithAir = this.getArguments().getValue("replace-with-air", false, (Action)this);
        if (replaceWithAir || !helmet.isEmpty()) {
            living.getEquipment().setHelmet(helmet);
        }
        if (replaceWithAir || !chestplate.isEmpty()) {
            living.getEquipment().setChestplate(chestplate);
        }
        if (replaceWithAir || !leggings.isEmpty()) {
            living.getEquipment().setLeggings(leggings);
        }
        if (replaceWithAir || !boots.isEmpty()) {
            living.getEquipment().setBoots(boots);
        }
    }

    @Override
    public ActionType getActionType() {
        return ActionType.ENTITY_SET_ARMOR;
    }
}

