/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.entityactions.params;

import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.entityactions.EntityAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;

public final class EntitySetHealthAction
extends EntityAction {
    public EntitySetHealthAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (livingEntity.isDead()) {
            ErrorUtils.sendCodingDebugLog(this.getPlanet(), "Can't set entity's health, livingEntity is dead.");
            return;
        }
        boolean add = this.getArguments().getValue("add", false, (Action)this);
        double health = this.getArguments().getValue("health", 20.0, (Action)this);
        if (add) {
            health += livingEntity.getHealth();
        }
        livingEntity.setHealth(health);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.ENTITY_SET_HEALTH;
    }
}

