/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.playeractions.communication;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.playeractions.PlayerAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public final class PlaySoundAction
extends PlayerAction {
    public PlaySoundAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    public void executePlayer(Player player) {
        SoundCategory category;
        String sound = this.getArguments().getValue("sound", "entity.player.levelup", (Action)this);
        ItemStack musicDisc = this.getArguments().getValue("sound", new ItemStack(Material.AIR), (Action)this);
        if (musicDisc.getType() != Material.AIR && musicDisc.getType().name().contains("MUSIC_DISC")) {
            sound = musicDisc.getType().name().toLowerCase().replace("music_disc_", "music_disc.");
        }
        float volume = this.getArguments().getValue("volume", 100.0f, (Action)this);
        float pitch = this.getArguments().getValue("pitch", 1.0f, (Action)this);
        String categoryString = this.getArguments().getValue("category", "ambient", (Action)this);
        Location location = this.getArguments().getValue("location", player.getLocation(), (Action)this);
        long seed = this.getArguments().getValue("seed", 0L, (Action)this);
        try {
            category = SoundCategory.valueOf((String)categoryString.toUpperCase());
        }
        catch (Exception error) {
            category = SoundCategory.AMBIENT;
        }
        if (this.getArguments().pathExists("seed")) {
            player.playSound(location, sound, category, volume, pitch, seed);
        } else {
            player.playSound(location, sound, category, volume, pitch);
        }
    }

    @Override
    public ActionType getActionType() {
        return ActionType.PLAYER_PLAY_SOUND;
    }
}

