/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.playeractions.inventory;

import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.playeractions.PlayerAction;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.playeractions.inventory.CustomMenu;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.coding.exceptions.TooManyOpenedMenusException;

public final class OpenInventoryAction
extends PlayerAction {
    public OpenInventoryAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    public void executePlayer(Player player) {
        if (this.getPlanet().getLimits().cantOpenMenu(player)) {
            throw new TooManyOpenedMenusException(player.getName());
        }
        String inventoryTypeString = this.getArguments().getValue("type", "chest", (Action)this);
        InventoryType inventoryType = InventoryType.CHEST;
        try {
            inventoryType = InventoryType.valueOf((String)inventoryTypeString.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String title = this.getArguments().getValue("title", inventoryType.getDefaultTitle(), (Action)this);
        if (!inventoryType.isCreatable()) {
            inventoryType = InventoryType.CHEST;
        }
        player.openInventory(new CustomMenu(inventoryType, title).getInventory());
    }

    @Override
    public ActionType getActionType() {
        return ActionType.PLAYER_OPEN_INVENTORY_VIEW;
    }
}

