/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.playeractions.inventory;

import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.playeractions.PlayerAction;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.playeractions.inventory.CustomMenu;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.coding.exceptions.TooManyOpenedMenusException;

public final class SetMenuSizeAction
extends PlayerAction {
    public SetMenuSizeAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    public void executePlayer(Player player) {
        if (!(player.getOpenInventory().getTopInventory().getHolder() instanceof CustomMenu)) {
            return;
        }
        InventoryView oldInventory = player.getOpenInventory();
        int rows = this.getArguments().getValue("rows", 6, (Action)this);
        if (rows > 6) {
            rows = 6;
        } else if (rows < 1) {
            rows = 1;
        }
        Inventory newInventory = new CustomMenu(rows * 9, oldInventory.getTitle()).getInventory();
        for (int i = 0; i < newInventory.getSize() && i < oldInventory.getTopInventory().getSize(); ++i) {
            newInventory.setItem(i, oldInventory.getTopInventory().getItem(i));
        }
        if (this.getPlanet().getLimits().cantOpenMenu(player)) {
            throw new TooManyOpenedMenusException(player.getName());
        }
        player.openInventory(newInventory);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.PLAYER_SET_INVENTORY_VIEW_ROWS;
    }
}

