/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.repeatactions;

import java.util.Iterator;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionsHandler;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.MultiAction;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.coding.exceptions.TooManyRepeatsException;
import ua.mcchickenstudio.opencreative.planets.PlanetRunnable;

public abstract class RepeatAction
extends MultiAction {
    private int calls = 0;

    public RepeatAction(Executor executor, Target target, int x, Arguments args, List<Action> actions) {
        super(executor, target, x, args, actions);
    }

    @Override
    public final void executeActions() {
        Iterator<Entity> iterator = this.getTargets().iterator();
        while (iterator.hasNext()) {
            Entity entity;
            this.entity = entity = iterator.next();
            if (!this.checkCanContinue()) {
                return;
            }
            ActionsHandler handler = new ActionsHandler(this);
            handler.executeActions(this.getActions());
            this.increaseCalls();
            if (handler.getWaitDelay() > 0L) {
                this.getPlanet().getTerritory().scheduleRunnable(new PlanetRunnable(this.getPlanet()){

                    @Override
                    public void execute() {
                        RepeatAction.this.executeActions();
                    }
                }, handler.getWaitDelay());
                continue;
            }
            this.executeActions();
        }
    }

    @Override
    protected void execute(Entity entity) {
        this.executeActions();
    }

    public void increaseCalls() {
        ++this.calls;
        if (this.calls > this.getPlanet().getLimits().getRepeatsAmountLimit()) {
            throw new TooManyRepeatsException();
        }
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                --RepeatAction.this.calls;
            }
        };
        this.getPlanet().getTerritory().addBukkitRunnable(runnable);
        runnable.runTaskLater((Plugin)OpenCreative.getPlugin(), 20L);
    }

    public abstract boolean checkCanContinue();

    @Override
    public ActionCategory getActionCategory() {
        return ActionCategory.REPEAT_ACTION;
    }
}

