/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.repeatactions.other;

import java.util.List;
import org.bukkit.Location;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.repeatactions.RepeatAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.coding.variables.ValueType;
import ua.mcchickenstudio.opencreative.coding.variables.VariableLink;

public final class RepeatForBlocksAction
extends RepeatAction {
    public RepeatForBlocksAction(Executor executor, Target target, int x, Arguments args, List<Action> actions) {
        super(executor, target, x, args, actions);
    }

    @Override
    public boolean checkCanContinue() {
        int maxZ;
        int maxY;
        VariableLink link = this.getArguments().getVariableLink("variable", this);
        if (!this.getArguments().pathExists("first") || !this.getArguments().pathExists("second") || link == null) {
            return false;
        }
        Location first = this.getArguments().getValue("first", this.getWorld().getSpawnLocation(), (Action)this);
        Location second = this.getArguments().getValue("second", this.getWorld().getSpawnLocation(), (Action)this);
        int minX = Math.min(first.getBlockX(), second.getBlockX());
        int minY = Math.min(first.getBlockY(), second.getBlockY());
        int minZ = Math.min(first.getBlockZ(), second.getBlockZ());
        int maxX = Math.max(first.getBlockX(), second.getBlockX());
        int count = (maxX - minX + 1) * ((maxY = Math.max(first.getBlockY(), second.getBlockY())) - minY + 1) * ((maxZ = Math.max(first.getBlockZ(), second.getBlockZ())) - minZ + 1);
        if (count > this.getPlanet().getLimits().getModifyingBlocksLimit()) {
            return false;
        }
        int currentX = this.arguments.getValue("current-x", minX, (Action)this);
        int currentY = this.arguments.getValue("current-y", minY, (Action)this);
        int currentZ = this.arguments.getValue("current-z", minZ - 1, (Action)this);
        if (++currentZ > maxZ) {
            currentZ = minZ;
            if (++currentX > maxX) {
                currentX = minX;
                ++currentY;
            }
        }
        if (currentY > maxY) {
            this.arguments.removeArgumentValue("current-x", "current-y", "current-z");
            return false;
        }
        this.setVarValue(link, new Location(this.getWorld(), (double)currentX, (double)currentY, (double)currentZ));
        this.arguments.setArgumentValue("current-x", ValueType.NUMBER, currentX);
        this.arguments.setArgumentValue("current-y", ValueType.NUMBER, currentY);
        this.arguments.setArgumentValue("current-z", ValueType.NUMBER, currentZ);
        return true;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.REPEAT_FOR_BLOCKS;
    }
}

