/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.variableactions.vector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.variableactions.VariableAction;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.variableactions.vector.RayTraceVectorAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.coding.variables.VariableLink;
import ua.mcchickenstudio.opencreative.utils.async.AsyncScheduler;
import ua.mcchickenstudio.opencreative.utils.millennium.math.AxisAlignedBB;
import ua.mcchickenstudio.opencreative.utils.millennium.math.BuildSpeed;
import ua.mcchickenstudio.opencreative.utils.millennium.math.FastMath;
import ua.mcchickenstudio.opencreative.utils.millennium.math.MovingObjectPosition;
import ua.mcchickenstudio.opencreative.utils.millennium.math.RayTrace;
import ua.mcchickenstudio.opencreative.utils.millennium.vectors.Vec2f;
import ua.mcchickenstudio.opencreative.utils.millennium.vectors.Vec3;

public final class RayTraceVectorMultiEntitiesAction
extends VariableAction {
    public RayTraceVectorMultiEntitiesAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        VariableLink hitVec = this.getArguments().getVariableLink("hitVec", this);
        Vector vector = this.getArguments().getValue("vector", new Vector(0, 0, 0), (Action)this);
        Location from = this.getArguments().getValue("from", new Location(entity.getWorld(), 0.0, 0.0, 0.0), (Action)this);
        AsyncScheduler.run(() -> {
            double range = this.getArguments().getValue("range", 3.0, (Action)this);
            List<Entity> list = RayTraceVectorMultiEntitiesAction.getEntitiesAroundPoint(from, range + 1.0);
            ArrayList<Location> resultList = new ArrayList<Location>();
            String filter = this.getArguments().getValue("filter", "no-filter", (Action)this);
            for (Entity e : list) {
                boolean isPlayer = e instanceof Player;
                if (filter.equals("only-players") && !isPlayer || filter.equals("only-entities") && (isPlayer || !(entity instanceof LivingEntity)) || e.isDead()) continue;
                Location to = e.getLocation();
                double x = to.getX();
                double y = to.getY();
                double z = to.getZ();
                BuildSpeed buildSpeed = this.getArguments().getValue("calculation", "vanilla-java", (Action)this).equals("vanilla-java") ? BuildSpeed.NORMAL : BuildSpeed.FAST;
                Vec2f rotation = RayTraceVectorAction.getYawPitch(vector);
                AxisAlignedBB aabb = new AxisAlignedBB(x - 0.3, y - 0.1, z - 0.3, x + 0.3, y + 1.9, z + 0.3);
                MovingObjectPosition result = RayTrace.rayCast(rotation.getX(), rotation.getY(), aabb, new Vec3(from.getX(), from.getY(), from.getZ()), range, buildSpeed);
                if (result == null) continue;
                Vec3 hit = result.hitVec;
                resultList.add(new Location(to.getWorld(), hit.xCoord, hit.yCoord, hit.zCoord));
            }
            this.setVarValue(hitVec, resultList);
        }, AsyncScheduler.getScheduler());
    }

    private static List<Entity> getEntitiesAroundPoint(Location location, double radius) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        World world = location.getWorld();
        int smallX = FastMath.floor((location.getX() - radius) / 16.0);
        int bigX = FastMath.floor((location.getX() + radius) / 16.0);
        int smallZ = FastMath.floor((location.getZ() - radius) / 16.0);
        int bigZ = FastMath.floor((location.getZ() + radius) / 16.0);
        for (int x = smallX; x <= bigX; ++x) {
            for (int z = smallZ; z <= bigZ; ++z) {
                if (!world.isChunkLoaded(x, z)) continue;
                entities.addAll(Arrays.asList(world.getChunkAt(x, z).getEntities()));
            }
        }
        entities.removeIf(entity -> entity.getLocation().distanceSquared(location) > radius * radius);
        return entities;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.VAR_DO_RAY_TRACE_MULTI_ENTITIES;
    }
}

