/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.appearance;

import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.WorldAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;

public final class CreateScoreboardAction
extends WorldAction {
    public CreateScoreboardAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        if (!this.getArguments().pathExists("name")) {
            return;
        }
        String name = this.getArguments().getValue("name", "board", (Action)this);
        String displayName = this.getArguments().getValue("display-name", "Scoreboard", (Action)this);
        try {
            Scoreboard scoreboard;
            if (this.getPlanet().getTerritory().getScoreboards().size() >= this.getPlanet().getLimits().getScoreboardsLimit()) {
                ErrorUtils.sendCodingDebugLog(this.getPlanet(), "Limit of " + this.getPlanet().getLimits().getScoreboardsLimit() + " scoreboards reached.");
                return;
            }
            if (this.getPlanet().getTerritory().getScoreboards().containsKey(name.toLowerCase())) {
                scoreboard = this.getPlanet().getTerritory().getScoreboards().get(name.toLowerCase());
                Objective objective = scoreboard.getObjective("score");
                if (objective == null) {
                    objective = scoreboard.registerNewObjective("score", Criteria.DUMMY, displayName);
                }
                objective.displayName((Component)Component.text((String)displayName));
            } else {
                scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
                Objective objective = scoreboard.registerNewObjective("score", Criteria.DUMMY, displayName);
                objective.setDisplaySlot(DisplaySlot.SIDEBAR);
            }
            this.getPlanet().getTerritory().getScoreboards().put(name.toLowerCase(), scoreboard);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public ActionType getActionType() {
        return ActionType.WORLD_CREATE_SCOREBOARD;
    }
}

