/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.appearance;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.WorldAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public final class DeleteScoreboardAction
extends WorldAction {
    public DeleteScoreboardAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        if (!this.getArguments().pathExists("scoreboards")) {
            return;
        }
        List<String> scoreboards = this.getArguments().getTextList("scoreboards", this);
        for (String name : scoreboards) {
            Scoreboard scoreboard = this.getPlanet().getTerritory().getScoreboards().get(name.toLowerCase());
            if (scoreboard == null) continue;
            Objective objective = scoreboard.getObjective("score");
            if (objective != null) {
                objective.unregister();
            }
            for (Player player : this.getPlanet().getPlayers()) {
                if (!player.getScoreboard().equals((Object)scoreboard)) continue;
                player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
            }
            this.getPlanet().getTerritory().getScoreboards().remove(name.toLowerCase());
        }
    }

    @Override
    public ActionType getActionType() {
        return ActionType.WORLD_DELETE_SCORE_BOARD;
    }
}

