/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.blocks;

import java.util.ArrayList;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.WorldAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.coding.variables.VariableLink;

public final class GetContainerItemsAction
extends WorldAction {
    public GetContainerItemsAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        VariableLink link = this.getArguments().getVariableLink("variable", this);
        Location location = this.getArguments().getValue("location", this.getWorld().getSpawnLocation(), (Action)this);
        ItemStack[] itemStackArray = location.getBlock().getState();
        if (itemStackArray instanceof InventoryHolder) {
            InventoryHolder container = (InventoryHolder)itemStackArray;
            for (ItemStack item : container.getInventory().getContents()) {
                items.add(Objects.requireNonNullElseGet(item, () -> new ItemStack(Material.AIR)));
            }
        }
        this.setVarValue(link, items);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.WORLD_GET_CONTAINER_ITEMS;
    }
}

